/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.clipboard;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.ComponentInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.clipboard.ImplicitChildCommand;
import org.eclipse.wb.internal.core.model.clipboard.PropertiesClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInfoMemento
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String KEY_MEMENTO = "KEY_MEMENTO";
    private final String m_componentClassName;
    private final IClipboardCreationSupport m_creationSupport;
    private final List<ClipboardCommand> m_commands = Lists.newArrayList();
    private transient JavaInfo m_javaInfo;
    private transient boolean m_applied;

    public static JavaInfoMemento createMemento(JavaInfo javaInfo) throws Exception {
        if (javaInfo instanceof AbstractComponentInfo) {
            return new ComponentInfoMemento((AbstractComponentInfo)javaInfo);
        }
        return new JavaInfoMemento(javaInfo);
    }

    public static boolean hasMemento(JavaInfo javaInfo) {
        try {
            IClipboardCreationSupport clipboard = javaInfo.getCreationSupport().getClipboard();
            return clipboard != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void apply(JavaInfo javaInfo) throws Exception {
        JavaInfoMemento memento = (JavaInfoMemento)javaInfo.getArbitraryValue(KEY_MEMENTO);
        memento.apply();
    }

    protected JavaInfoMemento(JavaInfo javaInfo) throws Exception {
        this.m_componentClassName = javaInfo.getDescription().getComponentClass().getName();
        this.m_creationSupport = javaInfo.getCreationSupport().getClipboard();
        Assert.isNotNull((Object)this.m_creationSupport, (String)"No clipboard CreationSupport for %s", (Object[])new Object[]{javaInfo});
        JavaInfoMemento.cleanUpAnonymous(this.m_creationSupport);
        JavaInfoMemento.addCommands(javaInfo, this.m_commands);
    }

    static void addCommands(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
        commands.add(new PropertiesClipboardCommand(javaInfo));
        for (JavaInfo child : javaInfo.getChildrenJava()) {
            if (!(child.getCreationSupport() instanceof IImplicitCreationSupport)) continue;
            commands.add(new ImplicitChildCommand(child));
        }
        javaInfo.getBroadcastJava().clipboardCopy(javaInfo, commands);
        for (ClipboardCommand command : commands) {
            JavaInfoMemento.cleanUpAnonymous(command);
        }
    }

    static void cleanUpAnonymous(Object o) throws Exception {
        int i = 0;
        while (i < 10) {
            Field field = ReflectionUtils.getFieldByName(o.getClass(), (String)("this$" + i));
            if (field != null) {
                field.set(o, null);
            }
            ++i;
        }
    }

    public String getComponentClassName() {
        return this.m_componentClassName;
    }

    public JavaInfo create(JavaInfo existingHierarchyObject) throws Exception {
        Assert.isLegal((!this.m_applied ? 1 : 0) != 0, (String)"This memento already applied.");
        if (this.m_javaInfo == null) {
            JavaInfo rootObject = existingHierarchyObject.getRootJava();
            AstEditor editor = rootObject.getEditor();
            Class<?> componentClass = JavaInfoUtils.getClassLoader(rootObject).loadClass(this.m_componentClassName);
            CreationSupport creationSupport = this.m_creationSupport.create(rootObject);
            this.m_javaInfo = JavaInfoUtils.createJavaInfo(editor, componentClass, creationSupport);
            this.m_javaInfo.putArbitraryValue(KEY_MEMENTO, this);
        }
        return this.m_javaInfo;
    }

    public void apply() throws Exception {
        Assert.isNotNull((Object)((Object)this.m_javaInfo), (String)"JavaInfo should be already created using create().");
        Assert.isLegal((this.m_javaInfo.getParent() != null ? 1 : 0) != 0, (String)"JavaInfo should be already bounds to the hierarchy.");
        Assert.isLegal((!this.m_applied ? 1 : 0) != 0, (String)"This memento already applied.");
        this.m_applied = true;
        this.m_javaInfo.getRootJava().refreshLight();
        this.m_creationSupport.apply(this.m_javaInfo);
        this.executeCommands();
    }

    private void executeCommands() throws Exception {
        for (ClipboardCommand command : this.m_commands) {
            command.execute(this.m_javaInfo);
        }
    }
}

