/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.wizards.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewCargoProjectWizardPage
extends WizardPage {
    private Set<IWorkingSet> workingSets;
    private File directory;
    private String projectName;
    private Boolean isDirectoryAndProjectLinked = true;
    private IPreferenceStore store = CorrosionPlugin.getDefault().getPreferenceStore();
    private Text locationText;
    private Label projectNameLabel;
    private Text projectNameText;
    private ControlDecoration locationControlDecoration;
    private ControlDecoration projectNameControlDecoration;
    private Button binCheckBox;
    private Button vcsCheckBox;
    private Button gitRadioButton;
    private Button hgRadioButton;
    private Button pijulRadioButton;
    private Button fossilRadioButton;
    private WorkingSetGroup workingSetsGroup;

    protected NewCargoProjectWizardPage() {
        super(NewCargoProjectWizardPage.class.getName());
        this.setTitle(Messages.NewCargoProjectWizardPage_title);
        this.setDescription(Messages.NewCargoProjectWizardPage_description);
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        URL url = bundle.getEntry("images/cargo.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.setImageDescriptor(imageDescriptor);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        if (this.isDirectoryAndProjectLinked.booleanValue()) {
            return this.directory;
        }
        return new File(this.directory.toString(), this.projectName);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSetsGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(Set<IWorkingSet> workingSets) {
        this.workingSets = workingSets;
    }

    public boolean isBinaryTemplate() {
        return this.binCheckBox.getSelection();
    }

    public String getVCS() {
        if (this.vcsCheckBox.getSelection()) {
            if (this.gitRadioButton.getSelection()) {
                return "git";
            }
            if (this.hgRadioButton.getSelection()) {
                return "hg";
            }
            if (this.pijulRadioButton.getSelection()) {
                return "pijul";
            }
            if (this.fossilRadioButton.getSelection()) {
                return "fossil";
            }
        }
        return "none";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(4, false));
        this.createLocationPart(container);
        this.createTemplatePart(container);
        this.createVcsPart(container);
        this.createWorkingSetPart(container);
        if (this.directory != null) {
            this.updateDirectory(this.directory.getAbsolutePath());
        }
    }

    public boolean isPageComplete() {
        String locationError = "";
        String projectNameError = "";
        String cargoError = "";
        File cargo = new File(this.store.getString("corrosion.rustup_cargoPath"));
        if (!(cargo.exists() && cargo.isFile() && cargo.canExecute())) {
            cargoError = Messages.NewCargoProjectWizardPage_cargoCommandNotFound;
        } else if (this.directory == null || this.directory.getPath().isEmpty()) {
            locationError = Messages.NewCargoProjectWizardPage_emptyDirectory;
        } else if (this.projectName == null || this.projectName.isEmpty()) {
            projectNameError = Messages.NewCargoProjectWizardPage_emptyProjectName;
        } else if (this.directory.isFile()) {
            locationError = Messages.NewCargoProjectWizardPage_fileExisting;
        } else if (this.directory.getParentFile() == null || !this.directory.exists() && !this.directory.getParentFile().canWrite()) {
            locationError = Messages.NewCargoProjectWizardPage_cannotCreateDirectory;
        } else if (this.directory.exists() && !this.directory.canWrite()) {
            locationError = Messages.NewCargoProjectWizardPage_cannotWriteInDirectory;
        } else {
            File cargoProject = new File(this.directory, ".project");
            if (cargoProject.exists()) {
                try {
                    IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(Path.fromOSString((String)cargoProject.getAbsolutePath()));
                    if (!desc.getName().equals(this.projectName)) {
                        projectNameError = String.valueOf(Messages.NewCargoProjectWizardPage_projectNameDoesntMatchDotProject) + desc.getName();
                    }
                }
                catch (CoreException e) {
                    projectNameError = Messages.NewCargoProjectWizardPage_InvalidDotProjectInDirectory;
                }
            } else {
                IProject project = null;
                try {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                    if (project.exists() && (project.getLocation() == null || !this.directory.getAbsoluteFile().equals(project.getLocation().toFile().getAbsoluteFile()))) {
                        projectNameError = Messages.NewCargoProjectWizardPage_projectNameAlreadyUsed;
                    }
                }
                catch (IllegalArgumentException ex) {
                    projectNameError = Messages.NewCargoProjectWizardPage_invalidProjectName;
                }
            }
        }
        String error = String.valueOf(locationError) + projectNameError + cargoError;
        if (error.isEmpty()) {
            this.setErrorMessage(null);
            this.projectNameControlDecoration.hide();
            this.locationControlDecoration.hide();
        } else {
            if (!locationError.isEmpty()) {
                this.locationControlDecoration.showHoverText(locationError);
                this.locationControlDecoration.show();
                this.projectNameControlDecoration.hide();
            } else if (!projectNameError.isEmpty()) {
                this.projectNameControlDecoration.showHoverText(projectNameError);
                this.projectNameControlDecoration.show();
                this.locationControlDecoration.hide();
            }
            this.setErrorMessage(error);
        }
        return error.isEmpty();
    }

    private void createLocationPart(Composite container) {
        Label locationLabel = new Label(container, 0);
        locationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        locationLabel.setText(Messages.NewCargoProjectWizardPage_location);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.locationText = new Text(container, 2048);
        GridData locationGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        locationGridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.locationText.setLayoutData((Object)locationGridData);
        this.locationControlDecoration = new ControlDecoration((Control)this.locationText, 16512);
        this.locationControlDecoration.setImage(errorImage);
        this.locationControlDecoration.setShowOnlyOnFocus(true);
        this.locationText.addModifyListener(e -> {
            this.updateDirectory(this.locationText.getText());
            this.setPageComplete(this.isPageComplete());
        });
        Button browseButton = new Button(container, 0);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        browseButton.setText(Messages.NewCargoProjectWizardPage_browse);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.updateDirectory(path);
            }
            this.setPageComplete(this.isPageComplete());
        }));
        Composite linesAboveLink = new Composite(container, 0);
        GridData linesAboveLinkLayoutData = new GridData(4, 4);
        linesAboveLinkLayoutData.widthHint = 30;
        linesAboveLinkLayoutData.heightHint = 30;
        linesAboveLink.setLayoutData((Object)linesAboveLinkLayoutData);
        linesAboveLink.addPaintListener(e -> {
            e.gc.setForeground(((Control)e.widget).getDisplay().getSystemColor(16));
            e.gc.drawLine(0, e.height / 2, e.width / 2, e.height / 2);
            e.gc.drawLine(e.width / 2, e.height / 2, e.width / 2, e.height);
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Button linkButton = new Button(container, 2);
        linkButton.setToolTipText(Messages.NewCargoProjectWizardPage_linkNameAndFolder);
        linkButton.setSelection(true);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (InputStream iconStream = ((Object)((Object)this)).getClass().getResourceAsStream("/icons/link_obj.png");){
                Image linkImage = new Image((Device)linkButton.getDisplay(), iconStream);
                linkButton.setImage(linkImage);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            CorrosionPlugin.logError(e2);
        }
        linkButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(s -> {
            this.isDirectoryAndProjectLinked = linkButton.getSelection();
            this.projectNameText.setEnabled(!linkButton.getSelection());
            this.projectNameLabel.setEnabled(!linkButton.getSelection());
            this.updateProjectName();
        }));
        this.projectNameLabel = new Label(container, 0);
        this.projectNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.projectNameLabel.setText(Messages.NewCargoProjectWizardPage_projectName);
        this.projectNameText = new Text(container, 2048);
        this.projectNameText.setEnabled(false);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.projectNameControlDecoration = new ControlDecoration((Control)this.projectNameText, 16512);
        this.projectNameControlDecoration.setImage(errorImage);
        this.projectNameControlDecoration.setShowOnlyOnFocus(true);
        this.projectNameText.addModifyListener(e -> {
            this.updateProjectName();
            this.setPageComplete(this.isPageComplete());
        });
        Composite linesBelowLink = new Composite(container, 0);
        GridData linesBelowLinkLayoutData = new GridData(4, 4);
        linesBelowLinkLayoutData.widthHint = 30;
        linesBelowLinkLayoutData.heightHint = 30;
        linesBelowLink.setLayoutData((Object)linesAboveLinkLayoutData);
        linesBelowLink.addPaintListener(e -> {
            e.gc.setForeground(((Control)e.widget).getDisplay().getSystemColor(16));
            e.gc.drawLine(0, e.height / 2, e.width / 2, e.height / 2);
            e.gc.drawLine(e.width / 2, e.height / 2, e.width / 2, 0);
        });
    }

    private void updateProjectName() {
        if (!this.isDirectoryAndProjectLinked.booleanValue()) {
            this.projectName = this.projectNameText.getText();
        } else if (this.projectName == null || this.directory != null && !this.projectName.equals(this.directory.getName())) {
            this.projectName = this.directory.getName();
            this.projectNameText.setText(this.projectName);
        }
    }

    private void updateDirectory(String directoryPath) {
        this.directory = new File(directoryPath);
        if (!this.locationText.getText().equals(directoryPath)) {
            this.locationText.setText(directoryPath);
        } else if (this.isDirectoryAndProjectLinked.booleanValue()) {
            this.updateProjectName();
        }
    }

    private void createTemplatePart(Composite container) {
        new Label(container, 0);
        this.binCheckBox = new Button(container, 32);
        this.binCheckBox.setText(Messages.NewCargoProjectWizardPage_useTemplate);
        this.binCheckBox.setSelection(true);
        this.binCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
    }

    private void createVcsPart(Composite container) {
        new Label(container, 0);
        this.vcsCheckBox = new Button(container, 32);
        this.vcsCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.vcsCheckBox.setText(Messages.NewCargoProjectWizardPage_useVCS);
        this.vcsCheckBox.addSelectionListener(SelectionListener.widgetSelectedAdapter(s -> {
            Boolean shouldBeEnabled = this.vcsCheckBox.getSelection();
            this.gitRadioButton.setEnabled(shouldBeEnabled.booleanValue());
            this.hgRadioButton.setEnabled(shouldBeEnabled.booleanValue());
            this.pijulRadioButton.setEnabled(shouldBeEnabled.booleanValue());
            this.fossilRadioButton.setEnabled(shouldBeEnabled.booleanValue());
        }));
        new Label(container, 0);
        Composite radioGroup = new Composite(container, 0);
        radioGroup.setLayout((Layout)new GridLayout(4, false));
        GridData radioGroupdGridData = new GridData(16384, 0x1000000, false, false, 3, 1);
        radioGroupdGridData.horizontalIndent = 15;
        radioGroup.setLayoutData((Object)radioGroupdGridData);
        this.gitRadioButton = new Button(radioGroup, 16);
        this.gitRadioButton.setText("Git");
        this.gitRadioButton.setEnabled(false);
        this.gitRadioButton.setSelection(true);
        this.hgRadioButton = new Button(radioGroup, 16);
        this.hgRadioButton.setText("Mercurial (hg)");
        this.hgRadioButton.setEnabled(false);
        this.pijulRadioButton = new Button(radioGroup, 16);
        this.pijulRadioButton.setText("Pijul");
        this.pijulRadioButton.setEnabled(false);
        this.fossilRadioButton = new Button(radioGroup, 16);
        this.fossilRadioButton.setText("Fossil");
        this.fossilRadioButton.setEnabled(false);
    }

    private void createWorkingSetPart(Composite container) {
        Composite workingSetComposite = new Composite(container, 0);
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        workingSetComposite.setLayoutData((Object)layoutData);
        workingSetComposite.setLayout((Layout)new GridLayout(1, false));
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage"};
        StructuredSelection wsSel = null;
        if (this.workingSets != null) {
            wsSel = new StructuredSelection(this.workingSets.toArray());
        }
        this.workingSetsGroup = new WorkingSetGroup(workingSetComposite, (IStructuredSelection)wsSel, workingSetIds);
    }
}

