/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;

public class ResolvableRepositoryInformation
extends RepositoryInformation {
    public ResolvableRepositoryInformation(Model graph, Resource repNode) {
        super(EndpointType.Other);
        this.initialize(graph, repNode);
    }

    public ResolvableRepositoryInformation(String repositoryId) {
        super(repositoryId, "http://" + repositoryId, ResolvableRepositoryInformation.location(repositoryId), EndpointType.Other);
    }

    protected void initialize(Model graph, Resource repNode) {
        this.setProperty("name", repNode.stringValue());
        Model repositoryId = graph.filter(repNode, Vocabulary.FEDX.REPOSITORY_NAME, null, new Resource[0]);
        String repoId = ((Statement)repositoryId.iterator().next()).getObject().stringValue();
        this.setProperty("location", ResolvableRepositoryInformation.location(repoId));
        String id = repoId;
        this.setProperty("id", id);
    }

    static String location(String repoId) {
        return "resolvable:" + repoId;
    }
}

