/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.util;

import java.nio.ByteBuffer;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.eclipse.rdf4j.sail.lmdb.util.Bytes;

public class GroupMatcher {
    public static final Bytes.RegionComparator NULL_REGION_COMPARATOR = (a, b) -> true;
    private final int length0;
    private final int length1;
    private final int length2;
    private final int length3;
    private final Bytes.RegionComparator cmp0;
    private final Bytes.RegionComparator cmp1;
    private final Bytes.RegionComparator cmp2;
    private final Bytes.RegionComparator cmp3;
    private final byte firstByte0;
    private final byte firstByte1;
    private final byte firstByte2;
    private final byte firstByte3;
    private final MatchFn matcher;

    public GroupMatcher(byte[] valueArray, boolean[] shouldMatch) {
        int len;
        byte fb;
        assert (shouldMatch.length == 4);
        int baseOffset = 0;
        this.firstByte0 = fb = valueArray[0];
        this.length0 = len = Varint.firstToLength(fb);
        this.cmp0 = shouldMatch[0] ? Bytes.capturedComparator(valueArray, 0, len) : NULL_REGION_COMPARATOR;
        this.firstByte1 = fb = valueArray[baseOffset += len];
        this.length1 = len = Varint.firstToLength(fb);
        this.cmp1 = shouldMatch[1] ? Bytes.capturedComparator(valueArray, baseOffset, len) : NULL_REGION_COMPARATOR;
        this.firstByte2 = fb = valueArray[baseOffset += len];
        this.length2 = len = Varint.firstToLength(fb);
        this.cmp2 = shouldMatch[2] ? Bytes.capturedComparator(valueArray, baseOffset, len) : NULL_REGION_COMPARATOR;
        this.firstByte3 = fb = valueArray[baseOffset += len];
        this.length3 = len = Varint.firstToLength(fb);
        this.cmp3 = shouldMatch[3] ? Bytes.capturedComparator(valueArray, baseOffset, len) : NULL_REGION_COMPARATOR;
        this.matcher = this.selectMatcher(shouldMatch);
    }

    public boolean matches(ByteBuffer other) {
        return this.matcher.matches(other);
    }

    private MatchFn selectMatcher(boolean[] shouldMatch) {
        byte mask = 0;
        if (shouldMatch[0]) {
            mask = (byte)(mask | 1);
        }
        if (shouldMatch[1]) {
            mask = (byte)(mask | 2);
        }
        if (shouldMatch[2]) {
            mask = (byte)(mask | 4);
        }
        if (shouldMatch[3]) {
            mask = (byte)(mask | 8);
        }
        switch (mask) {
            case 0: {
                return this::match0000;
            }
            case 1: {
                return this::match0001;
            }
            case 2: {
                return this::match0010;
            }
            case 3: {
                return this::match0011;
            }
            case 4: {
                return this::match0100;
            }
            case 5: {
                return this::match0101;
            }
            case 6: {
                return this::match0110;
            }
            case 7: {
                return this::match0111;
            }
            case 8: {
                return this::match1000;
            }
            case 9: {
                return this::match1001;
            }
            case 10: {
                return this::match1010;
            }
            case 11: {
                return this::match1011;
            }
            case 12: {
                return this::match1100;
            }
            case 13: {
                return this::match1101;
            }
            case 14: {
                return this::match1110;
            }
            case 15: {
                return this::match1111;
            }
        }
        throw new IllegalStateException("Unsupported matcher mask: " + mask);
    }

    private boolean match0000(ByteBuffer other) {
        return true;
    }

    private boolean match0001(ByteBuffer other) {
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0) {
            return this.length0 == 1 || this.cmp0.equals(otherFirst0, other);
        }
        return false;
    }

    private boolean match0010(ByteBuffer other) {
        this.skipAhead(other);
        byte otherFirst1 = other.get();
        if (this.firstByte1 == otherFirst1) {
            return this.length1 == 1 || this.cmp1.equals(otherFirst1, other);
        }
        return false;
    }

    private boolean match0011(ByteBuffer other) {
        byte otherFirst1;
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other)) && this.firstByte1 == (otherFirst1 = other.get())) {
            return this.length1 == 1 || this.cmp1.equals(otherFirst1, other);
        }
        return false;
    }

    private boolean match0100(ByteBuffer other) {
        this.skipAhead(other);
        this.skipAhead(other);
        byte otherFirst2 = other.get();
        if (this.firstByte2 == otherFirst2) {
            return this.length2 == 1 || this.cmp2.equals(otherFirst2, other);
        }
        return false;
    }

    private boolean match0101(ByteBuffer other) {
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other))) {
            this.skipAhead(other);
            byte otherFirst2 = other.get();
            if (this.firstByte2 == otherFirst2) {
                return this.length2 == 1 || this.cmp2.equals(otherFirst2, other);
            }
        }
        return false;
    }

    private boolean match0110(ByteBuffer other) {
        byte otherFirst2;
        this.skipAhead(other);
        byte otherFirst1 = other.get();
        if (this.firstByte1 == otherFirst1 && (this.length1 == 1 || this.cmp1.equals(otherFirst1, other)) && this.firstByte2 == (otherFirst2 = other.get())) {
            return this.length2 == 1 || this.cmp2.equals(otherFirst2, other);
        }
        return false;
    }

    private void skipAhead(ByteBuffer other) {
        int i = Varint.firstToLength(other.get()) - 1;
        assert (i >= 0);
        if (i > 0) {
            other.position(i + other.position());
        }
    }

    private boolean match0111(ByteBuffer other) {
        byte otherFirst2;
        byte otherFirst1;
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other)) && this.firstByte1 == (otherFirst1 = other.get()) && (this.length1 == 1 || this.cmp1.equals(otherFirst1, other)) && this.firstByte2 == (otherFirst2 = other.get())) {
            return this.length2 == 1 || this.cmp2.equals(otherFirst2, other);
        }
        return false;
    }

    private boolean match1000(ByteBuffer other) {
        this.skipAhead(other);
        this.skipAhead(other);
        this.skipAhead(other);
        byte otherFirst3 = other.get();
        if (this.firstByte3 == otherFirst3) {
            return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
        }
        return false;
    }

    private boolean match1001(ByteBuffer other) {
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other))) {
            this.skipAhead(other);
            this.skipAhead(other);
            byte otherFirst3 = other.get();
            if (this.firstByte3 == otherFirst3) {
                return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
            }
        }
        return false;
    }

    private boolean match1010(ByteBuffer other) {
        this.skipAhead(other);
        byte otherFirst1 = other.get();
        if (this.firstByte1 == otherFirst1 && (this.length1 == 1 || this.cmp1.equals(otherFirst1, other))) {
            this.skipAhead(other);
            byte otherFirst3 = other.get();
            if (this.firstByte3 == otherFirst3) {
                return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
            }
        }
        return false;
    }

    private boolean match1011(ByteBuffer other) {
        byte otherFirst1;
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other)) && this.firstByte1 == (otherFirst1 = other.get()) && (this.length1 == 1 || this.cmp1.equals(otherFirst1, other))) {
            this.skipAhead(other);
            byte otherFirst3 = other.get();
            if (this.firstByte3 == otherFirst3) {
                return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
            }
        }
        return false;
    }

    private boolean match1100(ByteBuffer other) {
        byte otherFirst3;
        this.skipAhead(other);
        this.skipAhead(other);
        byte otherFirst2 = other.get();
        if (this.firstByte2 == otherFirst2 && (this.length2 == 1 || this.cmp2.equals(otherFirst2, other)) && this.firstByte3 == (otherFirst3 = other.get())) {
            return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
        }
        return false;
    }

    private boolean match1101(ByteBuffer other) {
        byte otherFirst0 = other.get();
        if (this.firstByte0 == otherFirst0 && (this.length0 == 1 || this.cmp0.equals(otherFirst0, other))) {
            byte otherFirst3;
            this.skipAhead(other);
            byte otherFirst2 = other.get();
            if (this.firstByte2 == otherFirst2 && (this.length2 == 1 || this.cmp2.equals(otherFirst2, other)) && this.firstByte3 == (otherFirst3 = other.get())) {
                return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
            }
        }
        return false;
    }

    private boolean match1110(ByteBuffer other) {
        byte otherFirst3;
        byte otherFirst2;
        this.skipAhead(other);
        byte otherFirst1 = other.get();
        if (this.firstByte1 == otherFirst1 && (this.length1 == 1 || this.cmp1.equals(otherFirst1, other)) && this.firstByte2 == (otherFirst2 = other.get()) && (this.length2 == 1 || this.cmp2.equals(otherFirst2, other)) && this.firstByte3 == (otherFirst3 = other.get())) {
            return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
        }
        return false;
    }

    private boolean match1111(ByteBuffer other) {
        byte otherFirst3;
        byte otherFirst2;
        byte otherFirst1;
        byte otherFirst0 = other.get();
        if (!(this.firstByte0 != otherFirst0 || this.length0 != 1 && !this.cmp0.equals(otherFirst0, other) || this.firstByte1 != (otherFirst1 = other.get()) || this.length1 != 1 && !this.cmp1.equals(otherFirst1, other) || this.firstByte2 != (otherFirst2 = other.get()) || this.length2 != 1 && !this.cmp2.equals(otherFirst2, other) || this.firstByte3 != (otherFirst3 = other.get()))) {
            return this.length3 == 1 || this.cmp3.equals(otherFirst3, other);
        }
        return false;
    }

    @FunctionalInterface
    private static interface MatchFn {
        public boolean matches(ByteBuffer var1);
    }
}

