/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.lmdb.LmdbContextIterator;
import org.eclipse.rdf4j.sail.lmdb.LmdbEvaluationStatistics;
import org.eclipse.rdf4j.sail.lmdb.LmdbStatementIterator;
import org.eclipse.rdf4j.sail.lmdb.NamespaceStore;
import org.eclipse.rdf4j.sail.lmdb.PersistentSet;
import org.eclipse.rdf4j.sail.lmdb.PersistentSetFactory;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LmdbSailStore
implements SailStore {
    final Logger logger = LoggerFactory.getLogger(LmdbSailStore.class);
    private final TripleStore tripleStore;
    private final ValueStore valueStore;
    private final ExecutorService tripleStoreExecutor = Executors.newCachedThreadPool();
    private final CircularBuffer<Operation> opQueue = new CircularBuffer(1024);
    private volatile Throwable tripleStoreException;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private boolean multiThreadingActive;
    private volatile boolean asyncTransactionFinished;
    private volatile boolean nextTransactionAsync;
    boolean enableMultiThreading = true;
    private PersistentSetFactory<Long> setFactory;
    private PersistentSet<Long> unusedIds;
    private PersistentSet<Long> nextUnusedIds;
    static final Operation COMMIT_TRANSACTION = () -> {};
    static final Operation ROLLBACK_TRANSACTION = () -> {};
    private final NamespaceStore namespaceStore;
    private final ReentrantLock sinkStoreAccessLock = new ReentrantLock();
    private final AtomicBoolean storeTxnStarted = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LmdbSailStore(File dataDir, LmdbStoreConfig config) throws IOException, SailException {
        this.setFactory = new PersistentSetFactory(dataDir);
        Function<Long, byte[]> encode = element -> {
            ByteBuffer bb = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            bb.putLong((long)element);
            return bb.array();
        };
        Function<ByteBuffer, Long> decode = buffer -> buffer.order(ByteOrder.BIG_ENDIAN).getLong();
        this.unusedIds = this.setFactory.createSet("unusedIds", encode, decode);
        this.nextUnusedIds = this.setFactory.createSet("nextUnusedIds", encode, decode);
        boolean initialized = false;
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(new File(dataDir, "values"), config);
            this.tripleStore = new TripleStore(new File(dataDir, "triples"), config);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.close();
            }
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    void rollback() throws SailException {
        this.sinkStoreAccessLock.lock();
        try {
            try {
                this.valueStore.rollback();
            }
            finally {
                if (this.multiThreadingActive) {
                    while (!this.opQueue.add(ROLLBACK_TRANSACTION)) {
                        if (this.tripleStoreException != null) {
                            throw this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                } else {
                    this.tripleStore.rollback();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to rollback LMDB transaction", (Throwable)e);
            throw e instanceof SailException ? (SailException)e : new SailException((Throwable)e);
        }
        finally {
            this.tripleStoreException = null;
            this.sinkStoreAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SailException {
        try {
            try {
                if (this.namespaceStore != null) {
                    this.namespaceStore.close();
                }
            }
            finally {
                try {
                    if (this.valueStore != null) {
                        this.valueStore.close();
                    }
                }
                finally {
                    block42: {
                        try {
                            if (this.tripleStore == null) break block42;
                            try {
                                this.running.set(false);
                                this.tripleStoreExecutor.shutdown();
                                try {
                                    while (!this.tripleStoreExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                                        this.logger.warn("Waiting for triple store executor to terminate");
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new InterruptedSailException((Throwable)e);
                                }
                            }
                            finally {
                                this.tripleStore.close();
                            }
                        }
                        finally {
                            if (this.setFactory != null) {
                                this.setFactory.close();
                                this.setFactory = null;
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close store", (Throwable)e);
            throw new SailException((Throwable)e);
        }
    }

    SailException wrapTripleStoreException() {
        return this.tripleStoreException instanceof SailException ? (SailException)this.tripleStoreException : new SailException(this.tripleStoreException);
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new LmdbEvaluationStatistics(this.valueStore, this.tripleStore);
    }

    public SailSource getExplicitSailSource() {
        return new LmdbSailSource(true);
    }

    public SailSource getInferredSailSource() {
        return new LmdbSailSource(false);
    }

    CloseableIteration<Resource> getContexts() throws IOException {
        final TxnManager.Txn txn = this.tripleStore.getTxnManager().createReadTxn();
        RecordIterator records = this.tripleStore.getAllTriplesSortedByContext(txn);
        CloseableIteration<? extends Statement> stIter1 = records == null ? this.createStatementIterator(txn, null, null, null, true, new Resource[0]) : new CloseableIteration<Statement>(records, this.valueStore);
        FilterIteration<Statement> stIter2 = new FilterIteration<Statement>(stIter1){

            protected boolean accept(Statement st) {
                return st.getContext() != null;
            }

            protected void handleClose() {
            }
        };
        return new ConvertingIteration<Statement, Resource>((CloseableIteration)stIter2){

            protected Resource convert(Statement sourceObject) throws SailException {
                return sourceObject.getContext();
            }

            protected void handleClose() throws SailException {
                txn.close();
                super.handleClose();
            }
        };
    }

    CloseableIteration<? extends Statement> createStatementIterator(TxnManager.Txn txn, Resource subj, IRI pred, Value obj, boolean explicit, Resource ... contexts) throws IOException {
        long subjID = -1L;
        if (subj != null && (subjID = this.valueStore.getId((Value)subj)) == -1L) {
            return new EmptyIteration();
        }
        long predID = -1L;
        if (pred != null && (predID = this.valueStore.getId((Value)pred)) == -1L) {
            return new EmptyIteration();
        }
        long objID = -1L;
        if (obj != null && (objID = this.valueStore.getId(obj)) == -1L) {
            return new EmptyIteration();
        }
        ArrayList<Long> contextIDList = new ArrayList<Long>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1L);
        } else {
            for (Resource context : contexts) {
                long contextID;
                if (context == null) {
                    contextIDList.add(0L);
                    continue;
                }
                if (context.isTriple() || (contextID = this.valueStore.getId((Value)context)) == -1L) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<LmdbStatementIterator> perContextIterList = new ArrayList<LmdbStatementIterator>(contextIDList.size());
        Iterator iterator = contextIDList.iterator();
        while (iterator.hasNext()) {
            long contextID = (Long)iterator.next();
            RecordIterator records = this.tripleStore.getTriples(txn, subjID, predID, objID, contextID, explicit);
            perContextIterList.add(new LmdbStatementIterator(records, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    private final class LmdbSailDataset
    implements SailDataset {
        private final boolean explicit;
        private final TxnManager.Txn txn;

        public LmdbSailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            try {
                this.txn = LmdbSailStore.this.tripleStore.getTxnManager().createReadTxn();
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
        }

        public void close() {
            this.txn.close();
        }

        public String getNamespace(String prefix) throws SailException {
            return LmdbSailStore.this.namespaceStore.getNamespace(prefix);
        }

        public CloseableIteration<? extends Namespace> getNamespaces() {
            return new CloseableIteratorIteration(LmdbSailStore.this.namespaceStore.iterator());
        }

        public CloseableIteration<? extends Resource> getContextIDs() throws SailException {
            try {
                return new LmdbContextIterator(LmdbSailStore.this.tripleStore.getContexts(this.txn), LmdbSailStore.this.valueStore);
            }
            catch (IOException e) {
                throw new SailException("Unable to get contexts", (Throwable)e);
            }
        }

        public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            try {
                return LmdbSailStore.this.createStatementIterator(this.txn, subj, pred, obj, this.explicit, contexts);
            }
            catch (IOException e) {
                try {
                    LmdbSailStore.this.logger.warn("Failed to get statements, retrying", (Throwable)e);
                    Thread.yield();
                    return LmdbSailStore.this.createStatementIterator(this.txn, subj, pred, obj, this.explicit, contexts);
                }
                catch (IOException e2) {
                    throw new SailException("Unable to get statements", (Throwable)e);
                }
            }
        }

        public CloseableIteration<? extends Statement> getStatements(StatementOrder statementOrder, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public Set<StatementOrder> getSupportedOrders(Resource subj, IRI pred, Value obj, Resource ... contexts) {
            return Set.of();
        }

        public Comparator<Value> getComparator() {
            return null;
        }
    }

    private final class LmdbSailSink
    implements SailSink {
        private final boolean explicit;

        public LmdbSailSink(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        public void close() {
        }

        public void prepare() throws SailException {
        }

        protected void filterUsedIdsInTripleStore() throws IOException {
            if (!LmdbSailStore.this.unusedIds.isEmpty()) {
                LmdbSailStore.this.tripleStore.filterUsedIds(LmdbSailStore.this.unusedIds);
            }
        }

        protected void handleRemovedIdsInValueStore() throws IOException {
            if (!LmdbSailStore.this.unusedIds.isEmpty()) {
                do {
                    LmdbSailStore.this.valueStore.gcIds(LmdbSailStore.this.unusedIds, LmdbSailStore.this.nextUnusedIds);
                    LmdbSailStore.this.unusedIds.clear();
                    if (LmdbSailStore.this.nextUnusedIds.isEmpty()) continue;
                    PersistentSet<Long> ids = LmdbSailStore.this.unusedIds;
                    LmdbSailStore.this.unusedIds = LmdbSailStore.this.nextUnusedIds;
                    LmdbSailStore.this.nextUnusedIds = ids;
                    this.filterUsedIdsInTripleStore();
                } while (!LmdbSailStore.this.unusedIds.isEmpty());
            }
        }

        public void flush() throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            boolean activeTxn = LmdbSailStore.this.storeTxnStarted.get();
            try {
                if (LmdbSailStore.this.multiThreadingActive) {
                    while (!LmdbSailStore.this.opQueue.add(COMMIT_TRANSACTION)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                }
                try {
                    LmdbSailStore.this.namespaceStore.sync();
                }
                finally {
                    if (LmdbSailStore.this.multiThreadingActive) {
                        while (!LmdbSailStore.this.asyncTransactionFinished) {
                            if (LmdbSailStore.this.tripleStoreException != null) {
                                throw LmdbSailStore.this.wrapTripleStoreException();
                            }
                            Thread.yield();
                        }
                    }
                    if (activeTxn) {
                        if (!LmdbSailStore.this.multiThreadingActive) {
                            LmdbSailStore.this.tripleStore.commit();
                            this.filterUsedIdsInTripleStore();
                        }
                        this.handleRemovedIdsInValueStore();
                        LmdbSailStore.this.valueStore.commit();
                        LmdbSailStore.this.storeTxnStarted.set(false);
                    }
                }
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.running.set(false);
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.running.set(false);
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.multiThreadingActive = false;
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void setNamespace(String prefix, String name) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.setNamespace(prefix, name);
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void removeNamespace(String prefix) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.removeNamespace(prefix);
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void clearNamespaces() throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.clear();
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        }

        public void clear(Resource ... contexts) throws SailException {
            this.removeStatements(null, null, null, this.explicit, contexts);
        }

        public void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
            this.addStatement(subj, pred, obj, this.explicit, ctx);
        }

        public void approveAll(Set<Statement> approved, Set<Resource> approvedContexts) {
            Statement last = null;
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                Iterator<Statement> iterator = approved.iterator();
                while (iterator.hasNext()) {
                    Statement statement;
                    last = statement = iterator.next();
                    Resource subj = statement.getSubject();
                    IRI pred = statement.getPredicate();
                    Value obj = statement.getObject();
                    Resource context = statement.getContext();
                    AddQuadOperation q = new AddQuadOperation();
                    q.s = LmdbSailStore.this.valueStore.storeValue((Value)subj);
                    q.p = LmdbSailStore.this.valueStore.storeValue((Value)pred);
                    q.o = LmdbSailStore.this.valueStore.storeValue(obj);
                    q.c = context == null ? 0L : LmdbSailStore.this.valueStore.storeValue((Value)context);
                    q.context = context;
                    q.explicit = this.explicit;
                    if (LmdbSailStore.this.multiThreadingActive) {
                        while (!LmdbSailStore.this.opQueue.add(q)) {
                            if (LmdbSailStore.this.tripleStoreException != null) {
                                throw LmdbSailStore.this.wrapTripleStoreException();
                            }
                            Thread.onSpinWait();
                        }
                        continue;
                    }
                    q.execute();
                }
            }
            catch (IOException | RuntimeException e) {
                LmdbSailStore.this.rollback();
                if (LmdbSailStore.this.multiThreadingActive) {
                    LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement.", (Throwable)e);
                } else {
                    LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement. Last statement that was attempted to be added: [ {} ]", (Object)last, (Object)e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SailException((Throwable)e);
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void deprecate(Statement statement) throws SailException {
            this.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), this.explicit, statement.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startTransaction(boolean preferThreading) throws SailException {
            AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
            synchronized (atomicBoolean) {
                if (LmdbSailStore.this.storeTxnStarted.compareAndSet(false, true)) {
                    LmdbSailStore.this.nextTransactionAsync = LmdbSailStore.this.multiThreadingActive = preferThreading && LmdbSailStore.this.enableMultiThreading;
                    LmdbSailStore.this.asyncTransactionFinished = false;
                    try {
                        if (LmdbSailStore.this.multiThreadingActive) {
                            if (LmdbSailStore.this.running.compareAndSet(false, true)) {
                                LmdbSailStore.this.tripleStoreException = null;
                                LmdbSailStore.this.tripleStoreExecutor.submit(() -> {
                                    try {
                                        while (LmdbSailStore.this.running.get()) {
                                            LmdbSailStore.this.tripleStore.startTransaction();
                                            while (true) {
                                                Operation op;
                                                if ((op = LmdbSailStore.this.opQueue.remove()) != null) {
                                                    if (op == COMMIT_TRANSACTION) {
                                                        LmdbSailStore.this.tripleStore.commit();
                                                        this.filterUsedIdsInTripleStore();
                                                        LmdbSailStore.this.nextTransactionAsync = false;
                                                        LmdbSailStore.this.asyncTransactionFinished = true;
                                                        break;
                                                    }
                                                    if (op == ROLLBACK_TRANSACTION) {
                                                        LmdbSailStore.this.tripleStore.rollback();
                                                        LmdbSailStore.this.nextTransactionAsync = false;
                                                        LmdbSailStore.this.asyncTransactionFinished = true;
                                                        break;
                                                    }
                                                    op.execute();
                                                    continue;
                                                }
                                                if (!LmdbSailStore.this.running.get()) {
                                                    LmdbSailStore.this.logger.warn("LmdbSailStore was closed while active transaction was waiting for the next operation. Forcing a rollback!");
                                                    LmdbSailStore.this.rollback();
                                                    continue;
                                                }
                                                if (Thread.interrupted()) {
                                                    throw new InterruptedException();
                                                }
                                                Thread.yield();
                                            }
                                            long start = 0L;
                                            while (LmdbSailStore.this.running.get() && !LmdbSailStore.this.nextTransactionAsync) {
                                                if (start == 0L) {
                                                    start = System.currentTimeMillis();
                                                }
                                                if (System.currentTimeMillis() - start > 2L) {
                                                    AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
                                                    synchronized (atomicBoolean) {
                                                        if (!LmdbSailStore.this.nextTransactionAsync) {
                                                            LmdbSailStore.this.running.set(false);
                                                            return;
                                                        }
                                                        continue;
                                                    }
                                                }
                                                Thread.yield();
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        LmdbSailStore.this.tripleStoreException = e;
                                        AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
                                        synchronized (atomicBoolean) {
                                            LmdbSailStore.this.running.set(false);
                                        }
                                    }
                                });
                            }
                        } else {
                            LmdbSailStore.this.tripleStore.startTransaction();
                        }
                        LmdbSailStore.this.valueStore.startTransaction(true);
                    }
                    catch (Exception e) {
                        LmdbSailStore.this.storeTxnStarted.set(false);
                        throw new SailException((Throwable)e);
                    }
                }
            }
        }

        private void addStatement(Resource subj, IRI pred, Value obj, boolean explicit, Resource context) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                AddQuadOperation q = new AddQuadOperation();
                q.s = LmdbSailStore.this.valueStore.storeValue((Value)subj);
                q.p = LmdbSailStore.this.valueStore.storeValue((Value)pred);
                q.o = LmdbSailStore.this.valueStore.storeValue(obj);
                q.c = context == null ? 0L : LmdbSailStore.this.valueStore.storeValue((Value)context);
                q.context = context;
                q.explicit = explicit;
                if (LmdbSailStore.this.multiThreadingActive) {
                    while (!LmdbSailStore.this.opQueue.add(q)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.onSpinWait();
                    }
                } else {
                    q.execute();
                }
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        private long removeStatements(long subj, long pred, long obj, boolean explicit, long[] contexts) throws IOException {
            long[] removeCount = new long[]{0L};
            for (long contextId : contexts) {
                LmdbSailStore.this.tripleStore.removeTriplesByContext(subj, pred, obj, contextId, explicit, quad -> {
                    removeCount[0] = removeCount[0] + 1L;
                    for (long id : quad) {
                        if (id == 0L) continue;
                        LmdbSailStore.this.unusedIds.add(id);
                    }
                });
            }
            return removeCount[0];
        }

        private long removeStatements(Resource subj, IRI pred, Value obj, final boolean explicit, Resource ... contexts) throws SailException {
            Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                long objID;
                long predID;
                long subjID;
                this.startTransaction(false);
                if (subj != null) {
                    subjID = LmdbSailStore.this.valueStore.getId((Value)subj);
                    if (subjID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    subjID = -1L;
                }
                if (pred != null) {
                    predID = LmdbSailStore.this.valueStore.getId((Value)pred);
                    if (predID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    predID = -1L;
                }
                if (obj != null) {
                    objID = LmdbSailStore.this.valueStore.getId(obj);
                    if (objID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    objID = -1L;
                }
                final long[] contextIds = new long[contexts.length == 0 ? 1 : contexts.length];
                if (contexts.length == 0) {
                    contextIds[0] = -1L;
                } else {
                    for (int i = 0; i < contexts.length; ++i) {
                        long id;
                        Resource context = contexts[i];
                        contextIds[i] = context == null ? 0L : ((id = LmdbSailStore.this.valueStore.getId((Value)context)) != -1L ? id : Long.MAX_VALUE);
                    }
                }
                if (LmdbSailStore.this.multiThreadingActive) {
                    final long[] removeCount = new long[1];
                    StatefulOperation removeOp = new StatefulOperation(){

                        @Override
                        public void execute() throws Exception {
                            try {
                                removeCount[0] = LmdbSailSink.this.removeStatements(subjID, predID, objID, explicit, contextIds);
                            }
                            finally {
                                this.finished = true;
                            }
                        }
                    };
                    while (!LmdbSailStore.this.opQueue.add(removeOp)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                    while (!removeOp.finished) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                    long l = removeCount[0];
                    return l;
                }
                long l = this.removeStatements(subjID, predID, objID, explicit, contextIds);
                return l;
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            return this.removeStatements(subj, pred, obj, this.explicit, contexts) > 0L;
        }

        public boolean supportsDeprecateByQuery() {
            return true;
        }
    }

    private final class LmdbSailSource
    extends BackingSailSource {
        private final boolean explicit;

        public LmdbSailSource(boolean explicit) {
            this.explicit = explicit;
        }

        public SailSource fork() {
            throw new UnsupportedOperationException("This store does not support multiple datasets");
        }

        public SailSink sink(IsolationLevel level) throws SailException {
            return new LmdbSailSink(this.explicit);
        }

        public LmdbSailDataset dataset(IsolationLevel level) throws SailException {
            return new LmdbSailDataset(this.explicit);
        }
    }

    static abstract class StatefulOperation
    implements Operation {
        volatile boolean finished = false;

        StatefulOperation() {
        }
    }

    class AddQuadOperation
    implements Operation {
        long s;
        long p;
        long o;
        long c;
        boolean explicit;
        Resource context;

        AddQuadOperation() {
        }

        @Override
        public void execute() throws IOException {
            if (!LmdbSailStore.this.unusedIds.isEmpty()) {
                LmdbSailStore.this.unusedIds.remove(this.s);
                LmdbSailStore.this.unusedIds.remove(this.p);
                LmdbSailStore.this.unusedIds.remove(this.o);
                LmdbSailStore.this.unusedIds.remove(this.c);
            }
            LmdbSailStore.this.tripleStore.storeTriple(this.s, this.p, this.o, this.c, this.explicit);
        }
    }

    static interface Operation {
        public void execute() throws Exception;
    }

    final class CircularBuffer<T> {
        private final T[] elements;
        private volatile int head = 0;
        private volatile int tail = 0;

        CircularBuffer(int size) {
            this.elements = new Object[size];
        }

        boolean add(T element) {
            if (this.head > 0 ? this.tail == this.head - 1 : this.tail == this.elements.length - 1) {
                return false;
            }
            this.elements[this.tail] = element;
            this.tail = (this.tail + 1) % this.elements.length;
            return true;
        }

        T remove() {
            T result = null;
            if (this.tail != this.head) {
                result = this.elements[this.head];
                this.head = (this.head + 1) % this.elements.length;
            }
            return result;
        }
    }
}

