/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class FilterTargetIsObject
extends FilterPlanNode {
    private final SailConnection connection;
    private final Resource[] dataGraph;

    public FilterTargetIsObject(SailConnection connection, Resource[] dataGraph, PlanNode parent) {
        super(parent);
        this.connection = connection;
        assert (this.connection != null);
        this.dataGraph = dataGraph;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value target = t.getActiveTarget();
        return this.connection.hasStatement(null, null, target, true, this.dataGraph);
    }

    @Override
    public String toString() {
        return "ExternalFilterTargetIsObject{}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterTargetIsObject that = (FilterTargetIsObject)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Arrays.equals(this.dataGraph, that.dataGraph);
        }
        return Objects.equals(this.connection, that.connection) && Arrays.equals(this.dataGraph, that.dataGraph);
    }

    @Override
    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(super.hashCode(), ((MemoryStoreConnection)this.connection).getSail(), Arrays.hashCode(this.dataGraph));
        }
        return Objects.hash(super.hashCode(), this.connection, Arrays.hashCode(this.dataGraph));
    }
}

