/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValueInFilter;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class InConstraintComponent
extends SimpleAbstractConstraintComponent {
    private final Set<Value> in;

    public InConstraintComponent(ShapeSource shapeSource, Resource in) {
        super(in);
        this.in = Collections.unmodifiableSet(new LinkedHashSet<Value>(ShaclAstLists.toList(shapeSource, in, Value.class)));
    }

    public InConstraintComponent(InConstraintComponent inConstraintComponent) {
        super(inConstraintComponent.getId());
        this.in = inConstraintComponent.in;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.IN, this.getId(), new Resource[0]);
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.in, this.getId(), model);
        }
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.InConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new InConstraintComponent(this);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return variable.asSparqlVariable() + " IN (" + this.getInSetAsString() + ")";
        }
        return variable.asSparqlVariable() + " NOT IN (" + this.getInSetAsString() + ")";
    }

    private String getInSetAsString() {
        return this.in.stream().map(targetNode -> {
            if (targetNode.isResource()) {
                return "<" + targetNode + ">";
            }
            if (targetNode.isLiteral()) {
                IRI datatype = ((Literal)targetNode).getDatatype();
                if (datatype == null) {
                    return "\"" + targetNode.stringValue() + "\"";
                }
                if (((Literal)targetNode).getLanguage().isPresent()) {
                    return "\"" + targetNode.stringValue() + "\"@" + ((Literal)targetNode).getLanguage().get();
                }
                return "\"" + targetNode.stringValue() + "\"^^<" + datatype.stringValue() + ">";
            }
            throw new IllegalStateException(targetNode.getClass().getSimpleName());
        }).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new ValueInFilter((PlanNode)parent, this.in);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InConstraintComponent that = (InConstraintComponent)o;
        return this.in.equals(that.in);
    }

    public int hashCode() {
        return this.in.hashCode() + "InConstraintComponent".hashCode();
    }
}

