/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public abstract class MemResource
implements MemValue,
Resource {
    final transient MemStatementList subjectStatements = new MemStatementList();
    final transient MemStatementList contextStatements = new MemStatementList();

    public MemStatementList getSubjectStatementList() {
        return this.subjectStatements;
    }

    public int getSubjectStatementCount() {
        return this.subjectStatements.size();
    }

    public void addSubjectStatement(MemStatement st) throws InterruptedException {
        this.subjectStatements.add(st);
    }

    public void removeSubjectStatement(MemStatement st) throws InterruptedException {
        this.subjectStatements.remove(st);
    }

    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) throws InterruptedException {
        this.subjectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public boolean hasSubjectStatements() {
        return !this.subjectStatements.isEmpty();
    }

    @Override
    public boolean hasContextStatements() {
        return !this.contextStatements.isEmpty();
    }

    public MemStatementList getContextStatementList() {
        return this.contextStatements;
    }

    public int getContextStatementCount() {
        return this.contextStatements.size();
    }

    public void addContextStatement(MemStatement st) throws InterruptedException {
        this.contextStatements.add(st);
    }

    public void removeContextStatement(MemStatement st) throws InterruptedException {
        this.contextStatements.remove(st);
    }

    public void cleanSnapshotsFromContextStatements(int currentSnapshot) throws InterruptedException {
        this.contextStatements.cleanSnapshots(currentSnapshot);
    }
}

