/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.config;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.config.SailImplConfig;

public abstract class AbstractSailImplConfig
implements SailImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private String type;
    private long iterationCacheSyncThreshold;
    private long connectionTimeOut;

    public AbstractSailImplConfig() {
    }

    public AbstractSailImplConfig(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws SailConfigException {
        if (this.type == null) {
            throw new SailConfigException("No type specified for sail implementation");
        }
    }

    @Override
    public Resource export(Model m) {
        BNode implNode = Values.bnode();
        if (this.type != null) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sail.type, Values.literal(this.type), new Resource[0]);
            } else {
                m.add(implNode, SailConfigSchema.SAILTYPE, Values.literal(this.type), new Resource[0]);
            }
        }
        if (this.iterationCacheSyncThreshold > 0L) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sail.iterationCacheSyncThreshold, Values.literal(this.iterationCacheSyncThreshold), new Resource[0]);
            } else {
                m.add(implNode, SailConfigSchema.ITERATION_CACHE_SYNC_THRESHOLD, Values.literal(this.iterationCacheSyncThreshold), new Resource[0]);
            }
        }
        if (this.connectionTimeOut > 0L) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sail.connectionTimeOut, Values.literal(this.connectionTimeOut), new Resource[0]);
            } else {
                m.add(implNode, SailConfigSchema.CONNECTION_TIME_OUT, Values.literal(this.connectionTimeOut), new Resource[0]);
            }
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        try {
            Configurations.getLiteralValue(m, implNode, CONFIG.Sail.type, SailConfigSchema.SAILTYPE).ifPresent(lit -> this.setType(lit.getLabel()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Sail.iterationCacheSyncThreshold, SailConfigSchema.ITERATION_CACHE_SYNC_THRESHOLD).ifPresent(lit -> this.setIterationCacheSyncThreshold(lit.longValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Sail.connectionTimeOut, SailConfigSchema.CONNECTION_TIME_OUT).ifPresent(lit -> this.setConnectionTimeOut(lit.longValue()));
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }

    @Override
    public long getIterationCacheSyncThreshold() {
        return this.iterationCacheSyncThreshold;
    }

    public void setIterationCacheSyncThreshold(long iterationCacheSyncThreshold) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
    }

    public long getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(long connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }
}

