/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.builder;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.GroupedPath;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.InversePath;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.PropertyPath;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.builder.EmptyPropertyPathBuilder;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.builder.PropertyPaths;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;

public class PropertyPathBuilder {
    private PropertyPath head;

    private PropertyPathBuilder() {
        this.head = null;
    }

    PropertyPathBuilder(Iri predicate) {
        this.head = PropertyPaths.p(predicate);
    }

    PropertyPathBuilder(IRI predicate) {
        this(Rdf.iri(predicate));
    }

    public static PropertyPathBuilder of(Iri predicate) {
        return new PropertyPathBuilder(predicate);
    }

    public static PropertyPathBuilder of(IRI predicate) {
        return new PropertyPathBuilder(predicate);
    }

    public PropertyPath build() {
        return this.head;
    }

    public PropertyPathBuilder inv() {
        Objects.requireNonNull(this.head);
        this.head = new InversePath(this.groupIfNotGrouped(this.head));
        return this;
    }

    private PropertyPath groupIfNotGrouped(PropertyPath path) {
        if (this.head instanceof GroupedPath) {
            return path;
        }
        return new GroupedPath(path);
    }

    public PropertyPathBuilder then(Iri predicate) {
        return this.then(PropertyPaths.p(predicate));
    }

    public PropertyPathBuilder then(IRI predicate) {
        return this.then(Rdf.iri(predicate));
    }

    public PropertyPathBuilder then(PropertyPath path) {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pSeq(this.head, path);
        return this;
    }

    public PropertyPathBuilder then(Consumer<EmptyPropertyPathBuilder> subtreeBuilder) {
        return this.withSubtree(subtreeBuilder, PropertyPaths::pSeq);
    }

    private PropertyPathBuilder withSubtree(Consumer<EmptyPropertyPathBuilder> subtreeBuilder, BiFunction<PropertyPath, PropertyPath, PropertyPath> assembler) {
        Objects.requireNonNull(this.head);
        EmptyPropertyPathBuilder b = new EmptyPropertyPathBuilder();
        subtreeBuilder.accept(b);
        this.head = assembler.apply(this.head, b.build());
        return this;
    }

    public PropertyPathBuilder or(Iri predicate) {
        return this.or(PropertyPaths.p(predicate));
    }

    public PropertyPathBuilder or(IRI predicate) {
        return this.or(Rdf.iri(predicate));
    }

    public PropertyPathBuilder or(PropertyPath path) {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pAlt(this.head, path);
        return this;
    }

    public PropertyPathBuilder or(Consumer<EmptyPropertyPathBuilder> subtreeBuilder) {
        return this.withSubtree(subtreeBuilder, PropertyPaths::pAlt);
    }

    public PropertyPathBuilder zeroOrMore() {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pZeroOrMore(this.head);
        return this;
    }

    public PropertyPathBuilder oneOrMore() {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pOneOrMore(this.head);
        return this;
    }

    public PropertyPathBuilder zeroOrOne() {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pZeroOrOne(this.head);
        return this;
    }

    public PropertyPathBuilder group() {
        Objects.requireNonNull(this.head);
        this.head = PropertyPaths.pGroup(this.head);
        return this;
    }
}

