/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;

class RDFStarEncodingStatement
implements Statement {
    private Statement delegate;

    RDFStarEncodingStatement(Statement delegate) {
        this.delegate = delegate;
    }

    public Resource getSubject() {
        return RDFStarUtil.toRDFEncodedValue(this.delegate.getSubject());
    }

    public IRI getPredicate() {
        return this.delegate.getPredicate();
    }

    public Value getObject() {
        return RDFStarUtil.toRDFEncodedValue(this.delegate.getObject());
    }

    public Resource getContext() {
        return this.delegate.getContext();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Statement) {
            Statement that = (Statement)other;
            return this.getObject().equals(that.getObject()) && this.getSubject().equals(that.getSubject()) && this.getPredicate().equals((Object)that.getPredicate()) && Objects.equals(this.getContext(), that.getContext());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject(), this.getContext());
    }
}

