/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.exception;

import java.lang.reflect.Constructor;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    protected static final Logger log = LoggerFactory.getLogger(ExceptionUtil.class);
    protected static final Pattern httpErrorPattern = Pattern.compile(".*<title>(.*)</title>.*", 32);

    public static QueryEvaluationException traceExceptionSource(Endpoint endpoint, Throwable ex, String additionalInfo) {
        String eID;
        if (endpoint == null) {
            log.warn("No endpoint found for connection, probably changed from different thread.");
            eID = "unknown";
        } else {
            eID = endpoint.getId();
        }
        Object message = ex.getMessage();
        message = message == null ? "n/a" : message;
        Matcher m = httpErrorPattern.matcher((CharSequence)message);
        if (m.matches()) {
            log.debug("HTTP error detected for endpoint " + eID + ":\n" + (String)message);
            message = "HTTP Error: " + m.group(1);
        } else {
            log.trace("No http error found");
        }
        if (!(ex instanceof QueryEvaluationException)) {
            message = (String)message + ". Original exception type: " + ex.getClass().getName();
        }
        QueryEvaluationException res = new QueryEvaluationException("@ " + eID + " - " + (String)message + ". " + additionalInfo, ex.getCause());
        res.setStackTrace(ex.getStackTrace());
        return res;
    }

    public static QueryEvaluationException traceExceptionSourceAndRepair(Endpoint endpoint, Throwable ex, String additionalInfo) {
        return ExceptionUtil.traceExceptionSource(endpoint, ex, additionalInfo);
    }

    public static String getExceptionString(String msg, Throwable ex) {
        return msg + " " + ex.getClass().getSimpleName() + ": " + ex.getMessage();
    }

    public static <E extends Exception> E changeExceptionMessage(String msgPrefix, E ex, Class<E> exClazz) {
        Exception newEx;
        Constructor<E> constructor = null;
        try {
            constructor = exClazz.getConstructor(String.class, Throwable.class);
        }
        catch (SecurityException e) {
            log.warn("Cannot change the message of exception class " + exClazz.getCanonicalName() + " due to SecurityException: " + e.getMessage());
            return ex;
        }
        catch (NoSuchMethodException e) {
            log.warn("Cannot change the message of exception class " + exClazz.getCanonicalName() + ": Constructor <String, Throwable> not found.");
            return ex;
        }
        try {
            newEx = (Exception)constructor.newInstance(msgPrefix + "." + ex.getMessage(), ex.getCause());
        }
        catch (Exception e) {
            log.warn("Cannot change the message of exception class " + exClazz.getCanonicalName() + " due to " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return ex;
        }
        newEx.setStackTrace(ex.getStackTrace());
        return (E)newEx;
    }

    public static Exception toException(Throwable t) {
        Object e;
        if (t instanceof QueryEvaluationException) {
            return (QueryEvaluationException)t;
        }
        if (t instanceof TimeoutException) {
            e = new QueryInterruptedException("Query evaluation has run into a timeout.", t);
        } else if (t instanceof Exception) {
            e = (Exception)t;
        } else {
            e = new QueryEvaluationException(t.getMessage() + ". Original type: " + t.getClass());
            ((Throwable)e).setStackTrace(t.getStackTrace());
        }
        return e;
    }

    public static QueryEvaluationException toQueryEvaluationException(Throwable t) {
        Exception res = ExceptionUtil.toException(t);
        if (res instanceof QueryEvaluationException) {
            return (QueryEvaluationException)((Object)res);
        }
        return new QueryEvaluationException((Throwable)res);
    }
}

