/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.experimental;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Add;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Copy;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.Move;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.queryrender.RenderUtils;
import org.eclipse.rdf4j.queryrender.sparql.experimental.AbstractSerializableParsedQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.FNFunction;
import org.eclipse.rdf4j.queryrender.sparql.experimental.PropertyPathSerializer;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedBooleanQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedConstructQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedUpdate;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

class PreprocessedQuerySerializer
extends AbstractQueryModelVisitor<RuntimeException> {
    private Map<Projection, SerializableParsedTupleQuery> queriesByProjection = new HashMap<Projection, SerializableParsedTupleQuery>();
    private AbstractSerializableParsedQuery currentQueryProfile = null;
    private SerializableParsedUpdate currentUpdate = null;
    protected StringBuilder builder;
    private Map<AbstractSerializableParsedQuery, Set<String>> renderedExtensionElements = Maps.newHashMap();
    private boolean insideFunction = false;

    public PreprocessedQuerySerializer() {
        this.builder = new StringBuilder();
    }

    public String serialize(SerializableParsedTupleQuery query) {
        this.builder = new StringBuilder();
        this.queriesByProjection.putAll(query.subQueriesByProjection);
        this.processTupleQuery(query);
        return this.builder.toString().trim();
    }

    public String serialize(SerializableParsedBooleanQuery query) {
        this.builder = new StringBuilder();
        this.queriesByProjection.putAll(query.subQueriesByProjection);
        this.processBooleanQuery(query);
        return this.builder.toString().trim();
    }

    public String serialize(SerializableParsedConstructQuery query) {
        this.builder = new StringBuilder();
        this.queriesByProjection.putAll(query.subQueriesByProjection);
        if (query.describe) {
            this.processDescribeQuery(query);
        } else {
            this.processConstructQuery(query);
        }
        return this.builder.toString().trim();
    }

    public String serialize(SerializableParsedUpdate update) {
        this.builder = new StringBuilder();
        this.queriesByProjection.putAll(update.subQueriesByProjection);
        this.processUpdate(update);
        return this.builder.toString().trim();
    }

    private void processDatasetClause(Dataset dataset) {
        if (dataset != null) {
            for (IRI defaultGraph : dataset.getDefaultGraphs()) {
                this.builder.append("FROM ");
                this.meet((Value)defaultGraph);
                this.builder.append(" \n");
            }
            for (IRI namedGraph : dataset.getNamedGraphs()) {
                this.builder.append("FROM NAMED ");
                this.meet((Value)namedGraph);
                this.builder.append(" \n");
            }
        }
    }

    private void processBooleanQuery(SerializableParsedBooleanQuery query) {
        this.renderedExtensionElements.put(query, Sets.newHashSet());
        this.currentQueryProfile = query;
        this.builder.append("ASK ");
        this.processDatasetClause(query.dataset);
        this.builder.append("WHERE ");
        this.builder.append("{ \n");
        this.meetWhereClause(query.whereClause);
        this.builder.append(" }\n ");
        if (query.bindings != null) {
            this.meet(query.bindings);
            this.builder.append("\n");
        }
    }

    private void processDescribeQuery(SerializableParsedConstructQuery query) {
        this.renderedExtensionElements.put(query, Sets.newHashSet());
        this.currentQueryProfile = query;
        this.builder.append("DESCRIBE ");
        for (ProjectionElemList pr : query.projection.getProjections()) {
            pr.visit((QueryModelVisitor)this);
        }
        this.processDatasetClause(query.dataset);
        if (query.whereClause != null && !(query.whereClause instanceof SingletonSet)) {
            this.builder.append("WHERE { \n");
            this.meetWhereClause(query.whereClause);
            this.builder.append(" }\n ");
        }
        if (query.limit != null) {
            this.writeLimit(query.limit);
            this.builder.append("\n");
        }
        if (query.bindings != null) {
            this.meet(query.bindings);
            this.builder.append("\n");
        }
    }

    private void processConstructQuery(SerializableParsedConstructQuery query) {
        this.renderedExtensionElements.put(query, Sets.newHashSet());
        this.currentQueryProfile = query;
        this.builder.append("CONSTRUCT { \n");
        this.meet(query.projection);
        this.builder.append("} ");
        this.processDatasetClause(query.dataset);
        this.builder.append("WHERE { \n");
        this.meetWhereClause(query.whereClause);
        this.builder.append(" }\n ");
        if (query.orderBy != null) {
            this.meet(query.orderBy);
            this.builder.append("\n");
        }
        if (query.limit != null) {
            this.writeLimit(query.limit);
            this.builder.append("\n");
        }
        if (query.bindings != null) {
            this.meet(query.bindings);
            this.builder.append("\n");
        }
    }

    private void processUpdate(SerializableParsedUpdate update) {
        this.currentUpdate = update;
        this.renderedExtensionElements.put(update, Sets.newHashSet());
        update.updateExpr.visit((QueryModelVisitor)this);
    }

    private void processTupleQuery(SerializableParsedTupleQuery query) {
        this.renderedExtensionElements.put(query, Sets.newHashSet());
        AbstractSerializableParsedQuery prevQuery = this.currentQueryProfile;
        this.currentQueryProfile = query;
        if (query.projection != null) {
            this.builder.append("SELECT ");
            if (query.modifier != null) {
                if (query.modifier.equals((Object)SerializableParsedTupleQuery.QueryModifier.DISTINCT)) {
                    this.builder.append("DISTINCT ");
                } else if (query.modifier.equals((Object)SerializableParsedTupleQuery.QueryModifier.REDUCED)) {
                    this.builder.append("REDUCED ");
                }
            }
            this.meet(query.projection.getProjectionElemList());
            this.builder.append("\n");
            this.processDatasetClause(query.dataset);
            this.builder.append("WHERE ");
        }
        this.builder.append("{ \n");
        this.meetWhereClause(query.whereClause);
        this.builder.append(" }\n ");
        if (query.groupBy != null) {
            this.meet(query.groupBy);
            if (query.having != null) {
                this.builder.append("HAVING (");
                query.having.getCondition().visit((QueryModelVisitor)this);
                this.builder.append(") ");
            }
            this.builder.append("\n");
        }
        if (query.orderBy != null) {
            this.meet(query.orderBy);
            this.builder.append("\n");
        }
        if (query.limit != null) {
            this.writeLimit(query.limit);
            this.builder.append("\n");
        }
        if (query.bindings != null) {
            this.meet(query.bindings);
            this.builder.append("\n");
        }
        this.currentQueryProfile = prevQuery;
    }

    public void meetWhereClause(TupleExpr whereClause) {
        if (whereClause != null) {
            whereClause.visit((QueryModelVisitor)this);
        }
    }

    public void meet(QueryRoot node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Add node) throws RuntimeException {
        this.builder.append("ADD ");
        if (node.isSilent()) {
            this.builder.append("SILENT ");
        }
        if (node.getSourceGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getSourceGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
        this.builder.append("TO ");
        if (node.getDestinationGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getDestinationGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
    }

    public void meet(And node) throws RuntimeException {
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append(" && ");
        node.getRightArg().visit((QueryModelVisitor)this);
    }

    public void meet(ArbitraryLengthPath node) throws RuntimeException {
        PropertyPathSerializer serializer = new PropertyPathSerializer();
        this.builder.append("\t");
        this.builder.append(serializer.serialize(node, this.currentQueryProfile));
        this.builder.append("\n");
    }

    public void meet(Avg node) throws RuntimeException {
        this.writeAsAggregationFunction("AVG", node.getArg(), node.isDistinct());
    }

    public void meet(Value node) {
        this.builder.append(RenderUtils.toSPARQL(node));
    }

    public void meet(BindingSetAssignment node) throws RuntimeException {
        ArrayList bindingNames = new ArrayList(node.getBindingNames());
        this.builder.append("VALUES (");
        for (String var : bindingNames) {
            this.builder.append("?");
            this.builder.append(var);
            this.builder.append(" ");
        }
        this.builder.append(") { ");
        for (BindingSet bs : node.getBindingSets()) {
            this.builder.append("(");
            for (String s : bindingNames) {
                if (bs.getValue(s) != null) {
                    this.meet(bs.getValue(s));
                    continue;
                }
                this.builder.append("UNDEF ");
            }
            this.builder.append(") ");
        }
        this.builder.append(" } ");
    }

    public void meet(BNodeGenerator node) throws RuntimeException {
        this.writeAsFunction("BNODE", Lists.newArrayList());
    }

    public void meet(Bound node) throws RuntimeException {
        this.writeAsFunction("BOUND", (ValueExpr)node.getArg());
    }

    public void meet(Clear clear) throws RuntimeException {
        this.builder.append("CLEAR ");
        if (clear.isSilent()) {
            this.builder.append("SILENT ");
        }
        if (clear.getGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(clear.getGraph());
        } else if (clear.getScope() != null) {
            switch (clear.getScope()) {
                case DEFAULT_CONTEXTS: {
                    this.builder.append("DEFAULT");
                    break;
                }
                case NAMED_CONTEXTS: {
                    this.builder.append("NAMED");
                    break;
                }
            }
        } else {
            this.builder.append("ALL");
        }
    }

    public void meet(Coalesce node) throws RuntimeException {
        this.writeAsFunction("COALESCE", node.getArguments());
    }

    public void meet(Compare node) throws RuntimeException {
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append(" ");
        this.builder.append(node.getOperator().getSymbol());
        this.builder.append(" ");
        node.getRightArg().visit((QueryModelVisitor)this);
    }

    public void meet(CompareAll node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(CompareAny node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Copy node) throws RuntimeException {
        this.builder.append("COPY ");
        if (node.isSilent()) {
            this.builder.append("SILENT ");
        }
        if (node.getSourceGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getSourceGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
        this.builder.append("TO ");
        if (node.getDestinationGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getDestinationGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
    }

    public void meet(Count node) throws RuntimeException {
        this.writeAsAggregationFunction("COUNT", node.getArg(), node.isDistinct());
    }

    public void meet(Create create) throws RuntimeException {
        this.builder.append("CREATE ");
        if (create.isSilent()) {
            this.builder.append("SILENT ");
        }
        if (create.getGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(create.getGraph());
        }
    }

    public void meet(Datatype node) throws RuntimeException {
        this.writeAsFunction("DATATYPE", node.getArg());
    }

    public void meet(DeleteData deleteData) throws RuntimeException {
        this.builder.append("DELETE DATA { \n");
        this.meetUpdateDataBlock(deleteData.getDataBlock());
        this.builder.append("} ");
    }

    public void meet(Difference node) throws RuntimeException {
        this.builder.append("{\n");
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append("}\n MINUS\n{\n");
        node.getRightArg().visit((QueryModelVisitor)this);
        this.builder.append("}\n");
    }

    public void meet(Distinct node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(EmptySet node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Exists node) throws RuntimeException {
        this.builder.append("EXISTS {");
        node.getSubQuery().visit((QueryModelVisitor)this);
        this.builder.append("} ");
    }

    public void meet(Extension node) throws RuntimeException {
        node.getArg().visit((QueryModelVisitor)this);
        for (ExtensionElem element : node.getElements()) {
            if (this.isTautologicalExtensionElem(element) || this.isExtensionElemAlreadyRendered(element)) continue;
            this.builder.append("\tBIND (");
            element.visit((QueryModelVisitor)this);
            this.builder.append(") . \n");
        }
    }

    protected boolean isExtensionElemAlreadyRendered(ExtensionElem element) {
        Set<String> alreadyRenderedList = this.renderedExtensionElements.get(this.currentQueryProfile);
        if (alreadyRenderedList != null) {
            return alreadyRenderedList.contains(element.getName());
        }
        return false;
    }

    protected void setExtensionElemAlreadyRendered(ExtensionElem element) {
        HashSet alreadyRenderedList = this.renderedExtensionElements.get(this.currentQueryProfile);
        if (alreadyRenderedList == null) {
            alreadyRenderedList = Sets.newHashSet();
            this.renderedExtensionElements.put(this.currentQueryProfile, alreadyRenderedList);
        }
        alreadyRenderedList.add(element.getName());
    }

    public void meet(ExtensionElem node) throws RuntimeException {
        node.getExpr().visit((QueryModelVisitor)this);
        this.builder.append(" AS ?");
        this.builder.append(node.getName());
        this.setExtensionElemAlreadyRendered(node);
    }

    public void meet(Filter node) throws RuntimeException {
        boolean isHaving = false;
        if (this.currentQueryProfile instanceof SerializableParsedTupleQuery) {
            isHaving = node.equals((Object)((SerializableParsedTupleQuery)this.currentQueryProfile).having);
        }
        if (this.currentQueryProfile == null || !isHaving) {
            node.getArg().visit((QueryModelVisitor)this);
            this.builder.append(" FILTER ");
            this.builder.append("(");
            node.getCondition().visit((QueryModelVisitor)this);
            this.builder.append(") ");
        }
    }

    public void meet(FunctionCall node) throws RuntimeException {
        this.writeAsFunction(this.getFunctionNameAsString(node), node.getArgs());
    }

    public void meet(Group node) throws RuntimeException {
        if (!node.getGroupBindingNames().isEmpty()) {
            this.builder.append("GROUP BY ");
            for (String name : node.getGroupBindingNames()) {
                this.builder.append("?");
                this.builder.append(name);
                this.builder.append(" ");
            }
        }
    }

    public void meet(GroupConcat node) throws RuntimeException {
        this.builder.append("GROUP_CONCAT(");
        if (node.isDistinct()) {
            this.builder.append("DISTINCT ");
        }
        node.getArg().visit((QueryModelVisitor)this);
        if (node.getSeparator() != null) {
            this.builder.append(";separator=");
            node.getSeparator().visit((QueryModelVisitor)this);
        }
        this.builder.append(") ");
    }

    public void meet(GroupElem node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(If node) throws RuntimeException {
        this.writeAsFunction("IF", Lists.newArrayList((Object[])new ValueExpr[]{node.getCondition(), node.getResult(), node.getAlternative()}));
    }

    public void meet(In node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(InsertData insertData) throws RuntimeException {
        this.builder.append("INSERT DATA { \n");
        this.meetUpdateDataBlock(insertData.getDataBlock());
        this.builder.append("} ");
    }

    protected void meetUpdateDataBlock(String dataBlock) throws RuntimeException {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TRIG);
        parser.setRDFHandler((RDFHandler)new AbstractRDFHandler(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                PreprocessedQuerySerializer.this.meet((Value)st.getSubject());
                PreprocessedQuerySerializer.this.builder.append(" ");
                PreprocessedQuerySerializer.this.meet((Value)st.getPredicate());
                PreprocessedQuerySerializer.this.builder.append(" ");
                PreprocessedQuerySerializer.this.meet(st.getObject());
                PreprocessedQuerySerializer.this.builder.append(" . \n");
            }
        });
        if (!StringUtils.isEmpty((CharSequence)dataBlock)) {
            try {
                parser.parse((Reader)new StringReader(dataBlock), "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void meet(Intersection node) throws RuntimeException {
        throw new UnsupportedOperationException("Unsupported operator: Intersection");
    }

    public void meet(IRIFunction node) throws RuntimeException {
        this.writeAsFunction("IRI", node.getArg());
    }

    public void meet(IsBNode node) throws RuntimeException {
        this.writeAsFunction("isBlank", node.getArg());
    }

    public void meet(IsLiteral node) throws RuntimeException {
        this.writeAsFunction("isLITERAL", node.getArg());
    }

    public void meet(IsNumeric node) throws RuntimeException {
        this.writeAsFunction("isNUMERIC", node.getArg());
    }

    public void meet(IsResource node) throws RuntimeException {
        this.writeAsFunction("isRESOURCE", node.getArg());
    }

    public void meet(IsURI node) throws RuntimeException {
        this.writeAsFunction("isURI", node.getArg());
    }

    public void meet(Join node) throws RuntimeException {
        node.getLeftArg().visit((QueryModelVisitor)this);
        node.getRightArg().visit((QueryModelVisitor)this);
    }

    public void meet(Label node) throws RuntimeException {
        this.writeAsFunction("LABEL", node.getArg());
    }

    public void meet(Lang node) throws RuntimeException {
        this.writeAsFunction("LANG", node.getArg());
    }

    public void meet(LangMatches node) throws RuntimeException {
        this.writeAsFunction("langMatches", Lists.newArrayList((Object[])new ValueExpr[]{node.getLeftArg(), node.getRightArg()}));
    }

    public void meet(LeftJoin node) throws RuntimeException {
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append(" OPTIONAL { ");
        node.getRightArg().visit((QueryModelVisitor)this);
        if (node.hasCondition()) {
            this.builder.append(" FILTER (");
            node.getCondition().visit((QueryModelVisitor)this);
            this.builder.append(")");
        }
        this.builder.append("} ");
    }

    public void meet(ListMemberOperator node) throws RuntimeException {
        Iterator argIter = node.getArguments().iterator();
        ValueExpr operand = (ValueExpr)argIter.next();
        operand.visit((QueryModelVisitor)this);
        this.builder.append(" IN (");
        if (argIter.hasNext()) {
            ((ValueExpr)argIter.next()).visit((QueryModelVisitor)this);
        }
        while (argIter.hasNext()) {
            this.builder.append(", ");
            ((ValueExpr)argIter.next()).visit((QueryModelVisitor)this);
        }
        this.builder.append(") ");
    }

    public void meet(Load load) throws RuntimeException {
        this.builder.append("LOAD ");
        if (load.isSilent()) {
            this.builder.append("SILENT ");
        }
        this.meet(load.getSource());
        if (load.getGraph() != null) {
            this.builder.append(" INTO GRAPH ");
            this.meet(load.getGraph());
        }
    }

    public void meet(LocalName node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(MathExpr node) throws RuntimeException {
        this.builder.append("(");
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append(node.getOperator().getSymbol());
        node.getRightArg().visit((QueryModelVisitor)this);
        this.builder.append(") ");
    }

    public void meet(Max node) throws RuntimeException {
        this.writeAsAggregationFunction("MAX", node.getArg(), node.isDistinct());
    }

    public void meet(Min node) throws RuntimeException {
        this.writeAsAggregationFunction("MIN", node.getArg(), node.isDistinct());
    }

    public void meet(Modify modify) throws RuntimeException {
        this.renderedExtensionElements.put(this.currentUpdate, Sets.newHashSet());
        if (modify.getDeleteExpr() != null) {
            this.builder.append("DELETE { \n");
            modify.getDeleteExpr().visit((QueryModelVisitor)this);
            this.builder.append(" } \n");
        }
        if (modify.getInsertExpr() != null) {
            this.builder.append("INSERT { \n");
            modify.getInsertExpr().visit((QueryModelVisitor)this);
            this.builder.append(" } \n");
        }
        if (modify.getWhereExpr() != null) {
            this.builder.append(" WHERE { \n");
            this.meetWhereClause(modify.getWhereExpr());
            this.builder.append(" }\n ");
            if (this.currentUpdate.limit != null) {
                this.writeLimit(this.currentUpdate.limit);
                this.builder.append("\n");
            }
            if (this.currentUpdate.bindings != null) {
                this.meet(this.currentUpdate.bindings);
                this.builder.append("\n");
            }
        }
    }

    public void meet(Move node) throws RuntimeException {
        this.builder.append("MOVE ");
        if (node.isSilent()) {
            this.builder.append("SILENT ");
        }
        if (node.getSourceGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getSourceGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
        this.builder.append("TO ");
        if (node.getDestinationGraph() != null) {
            this.builder.append("GRAPH ");
            this.meet(node.getDestinationGraph());
        } else {
            this.builder.append("DEFAULT ");
        }
    }

    public void meet(MultiProjection node) throws RuntimeException {
        HashMap valueMap = Maps.newHashMap();
        if (node.getArg() instanceof Extension) {
            Extension ext = (Extension)node.getArg();
            ext.getElements().stream().filter(elem -> elem.getExpr() instanceof ValueExpr).forEach(elem -> valueMap.put(elem.getName(), elem.getExpr()));
        }
        for (ProjectionElemList proj : node.getProjections()) {
            for (ProjectionElem elem2 : proj.getElements()) {
                if (valueMap.containsKey(elem2.getSourceName())) {
                    ValueExpr expr = (ValueExpr)valueMap.get(elem2.getSourceName());
                    if (expr instanceof BNodeGenerator) {
                        this.builder.append("_:" + elem2.getSourceName());
                    } else {
                        ((ValueExpr)valueMap.get(elem2.getSourceName())).visit((QueryModelVisitor)this);
                    }
                } else {
                    this.builder.append("?" + elem2.getSourceName());
                }
                this.builder.append(" ");
            }
            this.builder.append(" . \n");
        }
    }

    public void meet(Namespace node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Not node) throws RuntimeException {
        this.builder.append("!");
        super.meet(node);
    }

    public void meet(Or node) throws RuntimeException {
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append(" || ");
        node.getRightArg().visit((QueryModelVisitor)this);
    }

    public void meet(Order node) throws RuntimeException {
        if (!node.getElements().isEmpty()) {
            this.builder.append("ORDER BY ");
            for (OrderElem elem : node.getElements()) {
                elem.visit((QueryModelVisitor)this);
            }
        }
    }

    public void meet(OrderElem node) throws RuntimeException {
        if (!node.isAscending()) {
            this.builder.append("DESC(");
        }
        node.getExpr().visit((QueryModelVisitor)this);
        if (!node.isAscending()) {
            this.builder.append(")");
        }
        this.builder.append(" ");
    }

    public void meet(Projection node) throws RuntimeException {
        boolean isCurrentMainProjection = false;
        if (this.currentQueryProfile instanceof SerializableParsedTupleQuery) {
            isCurrentMainProjection = node.equals((Object)((SerializableParsedTupleQuery)this.currentQueryProfile).projection);
        } else if (this.currentQueryProfile instanceof SerializableParsedBooleanQuery) {
            isCurrentMainProjection = node.equals((Object)((SerializableParsedBooleanQuery)this.currentQueryProfile).projection);
        }
        if (this.currentQueryProfile == null || !isCurrentMainProjection) {
            this.builder.append("{ ");
            this.processTupleQuery(this.queriesByProjection.get(node));
            this.builder.append(" } ");
        }
    }

    public void meet(ProjectionElem node) throws RuntimeException {
        if (node.getSourceExpression() == null) {
            boolean isDescribe = false;
            if (this.currentQueryProfile instanceof SerializableParsedConstructQuery) {
                isDescribe = ((SerializableParsedConstructQuery)this.currentQueryProfile).describe;
            }
            if (node.getSourceName() == null || node.getTargetName().equals(node.getSourceName())) {
                if (isDescribe && this.currentQueryProfile.extensionElements.containsKey(node.getTargetName())) {
                    ExtensionElem elem = this.currentQueryProfile.extensionElements.get(node.getTargetName());
                    elem.getExpr().visit((QueryModelVisitor)this);
                    this.builder.append(" ");
                } else {
                    this.builder.append("?");
                    this.builder.append(node.getTargetName());
                    this.builder.append(" ");
                }
            } else {
                this.builder.append("(");
                this.builder.append("?");
                this.builder.append(node.getSourceName());
                this.builder.append(" ");
                this.builder.append("AS ");
                this.builder.append("?");
                this.builder.append(node.getTargetName());
                this.builder.append(" ");
                this.builder.append(") ");
            }
        } else if (!this.isTautologicalExtensionElem(node.getSourceExpression())) {
            this.builder.append("(");
            node.getSourceExpression().visit((QueryModelVisitor)this);
            this.builder.append(") ");
        } else {
            this.builder.append("?");
            this.builder.append(node.getTargetName());
            this.builder.append(" ");
        }
    }

    public void meet(ProjectionElemList node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Reduced node) throws RuntimeException {
        this.builder.append("REDUCED ");
        super.meet(node);
    }

    public void meet(Regex node) throws RuntimeException {
        this.writeAsFunction("REGEX", Lists.newArrayList((Object[])new ValueExpr[]{node.getLeftArg(), node.getRightArg(), node.getFlagsArg()}));
    }

    public void meet(SameTerm node) throws RuntimeException {
        this.writeAsFunction("sameTerm", Lists.newArrayList((Object[])new ValueExpr[]{node.getLeftArg(), node.getRightArg()}));
    }

    public void meet(Sample node) throws RuntimeException {
        this.writeAsAggregationFunction("SAMPLE", node.getArg(), node.isDistinct());
    }

    public void meet(Service node) throws RuntimeException {
        this.builder.append("SERVICE ");
        node.getServiceRef().visit((QueryModelVisitor)this);
        this.builder.append(" { \n");
        node.getServiceExpr().visit((QueryModelVisitor)this);
        this.builder.append("} \n");
    }

    public void meet(SingletonSet node) throws RuntimeException {
        this.builder.append("{ } \n");
    }

    public void meet(Slice node) throws RuntimeException {
        node.getArg().visit((QueryModelVisitor)this);
    }

    public void meet(StatementPattern node) throws RuntimeException {
        boolean isInContext;
        boolean bl = isInContext = node.getContextVar() != null;
        if (isInContext) {
            this.builder.append("GRAPH ");
            node.getContextVar().visit((QueryModelVisitor)this);
            this.builder.append(" { ");
        }
        this.builder.append("\t");
        node.getSubjectVar().visit((QueryModelVisitor)this);
        this.builder.append(" ");
        node.getPredicateVar().visit((QueryModelVisitor)this);
        this.builder.append(" ");
        node.getObjectVar().visit((QueryModelVisitor)this);
        this.builder.append(" . \n");
        if (isInContext) {
            this.builder.append(" } \n");
        }
    }

    public void meet(Str node) throws RuntimeException {
        this.writeAsFunction("STR", node.getArg());
    }

    public void meet(Sum node) throws RuntimeException {
        this.writeAsAggregationFunction("SUM", node.getArg(), node.isDistinct());
    }

    public void meet(Union node) throws RuntimeException {
        this.builder.append("{\n");
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append("}\n UNION\n{\n");
        node.getRightArg().visit((QueryModelVisitor)this);
        this.builder.append("}\n");
    }

    public void meet(ValueConstant node) throws RuntimeException {
        this.meet(node.getValue());
    }

    public void meet(Var node) throws RuntimeException {
        if (node.hasValue()) {
            this.meet(node.getValue());
        } else if (node.isAnonymous()) {
            if (this.currentQueryProfile.extensionElements.containsKey(node.getName())) {
                ExtensionElem elem = this.currentQueryProfile.extensionElements.get(node.getName());
                elem.getExpr().visit((QueryModelVisitor)this);
            } else if (this.currentQueryProfile.nonAnonymousVars.containsKey(node.getName())) {
                this.builder.append("?");
                this.builder.append(node.getName());
            } else {
                this.builder.append("_:");
                this.builder.append(node.getName());
            }
        } else {
            this.builder.append("?");
            this.builder.append(node.getName());
        }
        super.meet(node);
    }

    public void meet(ZeroLengthPath node) throws RuntimeException {
        super.meet(node);
    }

    private boolean isTautologicalExtensionElem(ExtensionElem val) {
        String varName = val.getName();
        if (val.getExpr() instanceof Var) {
            return ((Var)val.getExpr()).getName().equals(varName);
        }
        return false;
    }

    private void writeAsFunction(String name, ValueExpr arg) {
        this.builder.append(name);
        this.builder.append("(");
        boolean prevInsideFunction = this.insideFunction;
        this.insideFunction = true;
        arg.visit((QueryModelVisitor)this);
        this.insideFunction = prevInsideFunction;
        this.builder.append(") ");
    }

    private void writeAsFunction(String name, List<ValueExpr> args) {
        this.builder.append(name);
        this.builder.append("(");
        boolean prevInsideFunction = this.insideFunction;
        this.insideFunction = true;
        if (!args.isEmpty()) {
            args.get(0).visit((QueryModelVisitor)this);
            for (int i = 1; i < args.size(); ++i) {
                if (args.get(i) == null) continue;
                this.builder.append(",");
                args.get(i).visit((QueryModelVisitor)this);
            }
        }
        this.insideFunction = prevInsideFunction;
        this.builder.append(") ");
    }

    private void writeLimit(Slice node) throws RuntimeException {
        if (node.getLimit() > -1L) {
            this.builder.append("LIMIT ");
            this.builder.append(node.getLimit());
            this.builder.append(" ");
        }
        if (node.getOffset() > 0L) {
            this.builder.append("OFFSET ");
            this.builder.append(node.getOffset());
            this.builder.append(" ");
        }
    }

    private void writeAsAggregationFunction(String name, ValueExpr arg, boolean distinct) {
        this.builder.append(name);
        this.builder.append("(");
        if (distinct) {
            this.builder.append("DISTINCT ");
        }
        boolean prevInsideFunction = this.insideFunction;
        this.insideFunction = true;
        if (arg != null) {
            arg.visit((QueryModelVisitor)this);
        } else {
            this.builder.append("*");
        }
        this.insideFunction = prevInsideFunction;
        this.builder.append(") ");
    }

    protected String getFunctionNameAsString(FunctionCall expr) {
        String uri = expr.getURI();
        if (StringUtils.isEmpty((CharSequence)uri)) {
            return uri;
        }
        Optional<FNFunction> fnfunc = FNFunction.byUri(uri);
        if (fnfunc.isPresent()) {
            return fnfunc.get().getName();
        }
        if (NonIriFunctions.contains(uri)) {
            return uri;
        }
        return "<" + uri + ">";
    }

    protected static enum NonIriFunctions {
        STRLANG,
        STRDT,
        UUID,
        STRUUID,
        RAND,
        NOW,
        TZ,
        MD5,
        SHA1,
        SHA256,
        SHA384,
        SHA512;


        public static boolean contains(String token) {
            try {
                NonIriFunctions.valueOf(token.toUpperCase());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

