/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import com.google.common.base.Objects;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemTriple
implements Triple,
MemResource {
    private static final long serialVersionUID = -9085188980084028689L;
    private final transient Object creator;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final transient MemStatementList subjectStatements = new MemStatementList();
    private final transient MemStatementList objectStatements = new MemStatementList();

    public MemTriple(Object creator, MemResource subject, MemIRI predicate, MemValue object) {
        this.creator = creator;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    @Override
    public String stringValue() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<<");
        sb.append(this.getSubject());
        sb.append(" ");
        sb.append(this.getPredicate());
        sb.append(" ");
        sb.append(this.getObject());
        sb.append(">>");
        return sb.toString();
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return false;
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.getObjectStatementList().size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getSubjectStatementList() {
        return this.subjectStatements;
    }

    @Override
    public int getSubjectStatementCount() {
        return this.getSubjectStatementList().size();
    }

    @Override
    public void addSubjectStatement(MemStatement st) {
        this.subjectStatements.add(st);
    }

    @Override
    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        this.subjectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getContextStatementList() {
        return EMPTY_LIST;
    }

    @Override
    public int getContextStatementCount() {
        return 0;
    }

    @Override
    public void addContextStatement(MemStatement st) {
        throw new UnsupportedOperationException("RDF-star triples can not be used as context identifier");
    }

    @Override
    public void removeContextStatement(MemStatement st) {
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
    }

    @Override
    public MemResource getSubject() {
        return this.subject;
    }

    @Override
    public MemIRI getPredicate() {
        return this.predicate;
    }

    @Override
    public MemValue getObject() {
        return this.object;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subject, this.predicate, this.object});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Triple) {
            Triple that = (Triple)other;
            return this.subject.equals(that.getSubject()) && this.predicate.equals(that.getPredicate()) && this.object.equals(that.getObject());
        }
        return false;
    }
}

