/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.helpers;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;

public class BackgroundTupleResult
extends IteratingTupleQueryResult
implements Runnable,
TupleQueryResultHandler {
    private final TupleQueryResultParser parser;
    private final InputStream in;
    private final QueueCursor<BindingSet> queue;
    private final List<String> bindingNames = new ArrayList<String>();
    private final CountDownLatch bindingNamesReady = new CountDownLatch(1);
    private final CountDownLatch finishedParsing = new CountDownLatch(1);

    public BackgroundTupleResult(TupleQueryResultParser parser, InputStream in, WeakReference<?> callerRef) {
        this(new QueueCursor<BindingSet>(10, callerRef), parser, in);
    }

    public BackgroundTupleResult(QueueCursor<BindingSet> queue, TupleQueryResultParser parser, InputStream in) {
        super(Collections.emptyList(), queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.queue.done();
        }
        try {
            this.finishedParsing.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.queue.checkException();
        }
    }

    @Override
    public List<String> getBindingNames() {
        try {
            this.bindingNamesReady.await();
            List<String> list = this.bindingNames;
            return list;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            this.queue.checkException();
        }
    }

    @Override
    public void run() {
        try {
            try {
                this.parser.setQueryResultHandler(this);
                this.parser.parseQueryResult(this.in);
            }
            finally {
                this.in.close();
            }
        }
        catch (Exception e) {
            this.queue.toss(e);
        }
        finally {
            this.queue.done();
            this.bindingNamesReady.countDown();
            this.finishedParsing.countDown();
        }
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames.addAll(bindingNames);
        this.bindingNamesReady.countDown();
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            this.queue.put(bindingSet);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.queue.toss(e);
            this.queue.done();
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }
}

