/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import org.apache.solr.common.cloud.ZkNodeProps;

public class ZkCoreNodeProps {
    private ZkNodeProps nodeProps;

    public ZkCoreNodeProps(ZkNodeProps nodeProps) {
        this.nodeProps = nodeProps;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.nodeProps.getStr("base_url"), this.nodeProps.getStr("core"));
    }

    public String getNodeName() {
        return this.nodeProps.getStr("node_name");
    }

    public String getState() {
        return this.nodeProps.getStr("state");
    }

    public String getBaseUrl() {
        return this.nodeProps.getStr("base_url");
    }

    public String getCoreName() {
        return this.nodeProps.getStr("core");
    }

    public static String getCoreUrl(ZkNodeProps nodeProps) {
        return ZkCoreNodeProps.getCoreUrl(nodeProps.getStr("base_url"), nodeProps.getStr("core"));
    }

    public static String getCoreUrl(String baseUrl, String coreName) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(coreName);
        if (!sb.substring(sb.length() - 1).equals("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    public String toString() {
        return this.nodeProps.toString();
    }

    public ZkNodeProps getNodeProps() {
        return this.nodeProps;
    }

    public boolean isLeader() {
        return this.nodeProps.containsKey("leader");
    }
}

