/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIteratorCache;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatementIterator<X extends Exception>
extends LookAheadIteration<MemStatement, X> {
    private MemStatementList statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final MemResource[] contexts;
    private final boolean explicit;
    private final boolean explicitNotSpecified;
    private final int snapshot;
    private final boolean noIsolation;
    private int statementIndex;
    private boolean exhausted;
    private int matchingStatements;
    private int cachedHashCode = 0;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, Boolean explicit, int snapshot, MemResource ... contexts) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
        if (explicit == null) {
            this.explicitNotSpecified = true;
            this.explicit = false;
        } else {
            this.explicitNotSpecified = false;
            this.explicit = explicit;
        }
        this.snapshot = snapshot;
        this.noIsolation = snapshot < 0;
        this.statementIndex = 0;
    }

    public static CloseableIteration<MemStatement, SailException> cacheAwareInstance(MemStatementList smallestList, MemResource subj, MemIRI pred, MemValue obj, Boolean explicit, int snapshot, MemResource[] memContexts, MemStatementIteratorCache iteratorCache) {
        return new CacheAwareIteration<SailException>(new MemStatementIterator(smallestList, subj, pred, obj, explicit, snapshot, memContexts), iteratorCache);
    }

    @Override
    protected MemStatement getNextElement() {
        while (!this.exhausted) {
            MemStatement statement;
            if ((statement = this.statementList.getIfExists(this.statementIndex++)) == null) {
                this.exhausted = true;
                break;
            }
            if (!statement.matchesSPO(this.subject, this.predicate, this.object) || !this.matchesContext(statement) || !this.matchesExplicitAndSnapshot(statement)) continue;
            ++this.matchingStatements;
            return statement;
        }
        return null;
    }

    private boolean matchesContext(MemStatement statement) {
        if (this.contexts != null && this.contexts.length > 0) {
            for (MemResource context : this.contexts) {
                if (!statement.exactSameContext(context)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesExplicitAndSnapshot(MemStatement st) {
        return !(!this.explicitNotSpecified && this.explicit != st.isExplicit() || !this.noIsolation && !st.isInSnapshot(this.snapshot));
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            this.statementList = null;
        }
    }

    private boolean isCandidateForCache() {
        if (this.exhausted && this.statementIndex > 1000) {
            if (this.matchingStatements == 0) {
                return true;
            }
            if (this.matchingStatements < 100) {
                double ratio = ((double)this.statementIndex + 0.0) / (double)this.matchingStatements;
                return ratio > 100.0;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemStatementIterator)) {
            return false;
        }
        MemStatementIterator that = (MemStatementIterator)o;
        return this.explicit == that.explicit && this.explicitNotSpecified == that.explicitNotSpecified && this.snapshot == that.snapshot && this.noIsolation == that.noIsolation && this.subject == that.subject && this.predicate == that.predicate && this.object == that.object && Arrays.equals(this.contexts, that.contexts);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int cachedHashCode = Objects.hash(this.subject, this.predicate, this.object, this.explicit, this.explicitNotSpecified, this.snapshot, this.noIsolation);
            if (this.contexts != null) {
                if (this.contexts.length == 1) {
                    cachedHashCode = this.contexts[0] == null ? (cachedHashCode += 23) : 29 * cachedHashCode + this.contexts[0].hashCode();
                } else if (this.contexts.length > 0) {
                    cachedHashCode = 31 * cachedHashCode + Arrays.hashCode(this.contexts);
                }
            }
            this.cachedHashCode = cachedHashCode;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "MemStatementIterator{subject=" + this.subject + ", predicate=" + this.predicate + ", object=" + this.object + ", contexts=" + Arrays.toString(this.contexts) + ", explicit=" + this.explicit + ", explicitNotSpecified=" + this.explicitNotSpecified + ", snapshot=" + this.snapshot + ", noIsolation=" + this.noIsolation + "}";
    }

    public Stats getStats() {
        return new Stats(this.statementIndex, this.matchingStatements);
    }

    private static class CacheAwareIteration<X extends Exception>
    extends LookAheadIteration<MemStatement, X> {
        private final MemStatementIteratorCache iteratorCache;
        private final MemStatementIterator<X> memStatementIterator;
        private final CloseableIteration<MemStatement, X> cachedIterator;
        private Exception e;

        private CacheAwareIteration(MemStatementIterator<X> memStatementIterator, MemStatementIteratorCache iteratorCache) {
            if (iteratorCache.shouldBeCached(memStatementIterator)) {
                CloseableIteration<MemStatement, X> cachedIterator = null;
                try {
                    cachedIterator = iteratorCache.getCachedIterator(memStatementIterator);
                }
                catch (Exception e) {
                    this.e = e;
                }
                this.cachedIterator = cachedIterator;
                this.memStatementIterator = null;
            } else {
                this.memStatementIterator = memStatementIterator;
                this.cachedIterator = null;
            }
            this.iteratorCache = iteratorCache;
        }

        @Override
        protected MemStatement getNextElement() throws X {
            if (this.e != null) {
                throw this.e;
            }
            if (this.memStatementIterator != null) {
                if (this.memStatementIterator.hasNext()) {
                    return (MemStatement)this.memStatementIterator.next();
                }
            } else if (this.cachedIterator.hasNext()) {
                return (MemStatement)this.cachedIterator.next();
            }
            return null;
        }

        @Override
        protected void handleClose() throws X {
            try {
                super.handleClose();
            }
            finally {
                if (this.memStatementIterator != null) {
                    if (this.memStatementIterator.isCandidateForCache()) {
                        this.iteratorCache.incrementIteratorFrequencyMap(this.memStatementIterator);
                    }
                } else {
                    this.cachedIterator.close();
                }
            }
        }
    }

    static class Stats {
        private final int checkedStatements;
        private final int matchingStatements;

        public Stats(int checkStatements, int matchingStatements) {
            this.checkedStatements = checkStatements;
            this.matchingStatements = matchingStatements;
        }

        public String toString() {
            return "Stats{checkedStatements=" + this.checkedStatements + ", matchingStatements=" + this.matchingStatements + "}";
        }
    }
}

