/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;

public final class LeftJoinQueryEvaluationStep
implements QueryEvaluationStep {
    private final QueryEvaluationStep right;
    private final QueryValueEvaluationStep condition;
    private final QueryEvaluationStep left;
    private final LeftJoin leftJoin;
    private final Set<String> optionalVars;

    public static QueryEvaluationStep supply(EvaluationStrategy strategy, LeftJoin leftJoin, final QueryEvaluationContext context) {
        QueryValueEvaluationStep condition;
        final QueryEvaluationStep left = strategy.precompile(leftJoin.getLeftArg(), context);
        final QueryEvaluationStep right = strategy.precompile(leftJoin.getRightArg(), context);
        if (TupleExprs.containsSubquery(leftJoin.getRightArg())) {
            Set<String> leftBindingNames = leftJoin.getLeftArg().getBindingNames();
            Set<String> rightBindingNames = leftJoin.getRightArg().getBindingNames();
            HashSet<String> joinAttributeNames = new HashSet<String>(leftBindingNames);
            joinAttributeNames.retainAll(rightBindingNames);
            final String[] joinAttributes = joinAttributeNames.toArray(new String[0]);
            return new QueryEvaluationStep(){

                @Override
                public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                    return new HashJoinIteration(left, right, bs, true, joinAttributes, context);
                }
            };
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit(optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit(optionalVarCollector);
            condition = strategy.precompile(leftJoin.getCondition(), context);
        } else {
            condition = null;
        }
        return new LeftJoinQueryEvaluationStep(right, condition, left, leftJoin, optionalVarCollector);
    }

    public LeftJoinQueryEvaluationStep(QueryEvaluationStep right, QueryValueEvaluationStep condition, QueryEvaluationStep left, LeftJoin leftJoin, VarNameCollector optionalVarCollector) {
        this.right = right;
        this.condition = condition;
        this.left = left;
        this.leftJoin = leftJoin;
        this.optionalVars = optionalVarCollector.getVarNames();
        this.optionalVars.removeAll(leftJoin.getLeftArg().getBindingNames());
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
        HashSet<String> problemVars = new HashSet<String>(this.optionalVars);
        problemVars.retainAll(bindings.getBindingNames());
        if (problemVars.isEmpty()) {
            this.leftJoin.setAlgorithm(LeftJoinIterator.class.getSimpleName());
            return new LeftJoinIterator(this.left, this.right, this.condition, bindings, this.leftJoin.getBindingNames());
        }
        this.leftJoin.setAlgorithm(BadlyDesignedLeftJoinIterator.class.getSimpleName());
        return new BadlyDesignedLeftJoinIterator(this.left, this.right, this.condition, bindings, problemVars);
    }
}

