/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.FedXLeftJoin;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.federated.optimizer.OptimizerUtil;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class GenericInfoOptimizer
extends AbstractQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    protected boolean hasFilter = false;
    protected boolean hasUnion = false;
    protected List<Service> services = null;
    protected long limit = -1L;
    protected List<StatementPattern> stmts = new ArrayList<StatementPattern>();
    private boolean seenProjection = false;
    protected final QueryInfo queryInfo;

    public GenericInfoOptimizer(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public boolean hasFilter() {
        return this.hasFilter;
    }

    public boolean hasUnion() {
        return this.hasUnion;
    }

    public List<StatementPattern> getStatements() {
        return this.stmts;
    }

    public boolean hasLimit() {
        return this.limit > 0L;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        try {
            tupleExpr.visit((QueryModelVisitor)this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void meet(Union union) {
        this.hasUnion = true;
        super.meet(union);
    }

    public void meet(Filter filter) {
        this.hasFilter = true;
        super.meet(filter);
    }

    public void meet(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    public void meet(Join node) {
        NJoin newJoin = OptimizerUtil.flattenJoin(node, this.queryInfo);
        newJoin.visitChildren(this);
        node.replaceWith((QueryModelNode)newJoin);
    }

    public void meet(LeftJoin node) throws OptimizationException {
        FedXLeftJoin join = new FedXLeftJoin(node, this.queryInfo);
        join.visitChildren((QueryModelVisitor)this);
        node.replaceWith((QueryModelNode)join);
    }

    public void meet(StatementPattern node) {
        this.stmts.add(node);
    }

    public void meet(Projection node) throws OptimizationException {
        this.seenProjection = true;
        super.meet(node);
    }

    public void meet(Slice node) throws OptimizationException {
        if (!this.seenProjection) {
            this.limit = node.getLimit();
        }
        super.meet(node);
    }

    public boolean hasService() {
        return this.services != null && this.services.size() > 0;
    }

    public List<Service> getServices() {
        return this.services == null ? Collections.emptyList() : this.services;
    }
}

