/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesBackedNode
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ValuesBackedNode.class);
    private final SortedSet<Value> collection;
    private final ConstraintComponent.Scope scope;
    boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ValuesBackedNode(SortedSet<Value> collection, ConstraintComponent.Scope scope) {
        this.collection = collection;
        this.scope = scope;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final Iterator<Value> iterator;
            {
                this.iterator = ValuesBackedNode.this.collection.iterator();
            }

            @Override
            public void close() throws SailException {
            }

            @Override
            public boolean localHasNext() throws SailException {
                return this.iterator.hasNext();
            }

            @Override
            public ValidationTuple loggingNext() throws SailException {
                ArrayDeque<Value> targets = new ArrayDeque<Value>();
                targets.addLast(this.iterator.next());
                return new ValidationTuple(targets, ValuesBackedNode.this.scope, false);
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "ValuesBackedNode{collection=" + this.collection + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesBackedNode that = (ValuesBackedNode)o;
        return this.collection.equals(that.collection);
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

