/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class RemoveUnknownExecEnvironments
extends AbstractManifestMarkerResolution {
    public RemoveUnknownExecEnvironments(int type, IMarker marker) {
        super(type, marker);
    }

    @Override
    protected void createChange(BundleModel model) {
        IManifestHeader header = model.getBundle().getManifestHeader("Bundle-RequiredExecutionEnvironment");
        if (header instanceof RequiredExecutionEnvironmentHeader) {
            RequiredExecutionEnvironmentHeader reqHeader = (RequiredExecutionEnvironmentHeader)header;
            Set systemEnvs = TargetPlatformHelper.getPDEState().getfProvidedExecutionEnvironments();
            for (String ee : reqHeader.getEnvironments()) {
                if (systemEnvs.contains(ee)) continue;
                reqHeader.removeExecutionEnvironment(ee);
            }
        }
    }

    public String getLabel() {
        return PDEUIMessages.RemoveUnknownExecEnvironments_label;
    }
}

