/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.SuppressWarningsFixCore;
import org.eclipse.jdt.internal.corext.fix.UnusedSuppressWarningsFixCore;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.SuppressWarningsCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnusedSuppressWarningsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class SuppressWarningsBaseSubProcessor<T> {
    static final String ADD_SUPPRESSWARNINGS_ID = "org.eclipse.jdt.ui.correction.addSuppressWarnings";

    public static final boolean hasSuppressWarningsProposal(IJavaProject javaProject, int problemId) {
        String optionId;
        if (CorrectionEngine.getWarningToken((int)problemId) != null && (optionId = JavaCore.getOptionForConfigurableSeverity((int)problemId)) != null) {
            String optionValue = javaProject.getOption(optionId, true);
            return "info".equals(optionValue) || "warning".equals(optionValue) || "error".equals(optionValue) && "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", true));
        }
        return false;
    }

    public void getSuppressWarningsProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ImportDeclaration importStatement;
        if (problem.isError() && !"enabled".equals(context.getCompilationUnit().getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", true))) {
            return;
        }
        if ("disabled".equals(context.getCompilationUnit().getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.suppressWarnings", true))) {
            return;
        }
        String warningToken = CorrectionEngine.getWarningToken((int)problem.getProblemId());
        if (warningToken == null) {
            return;
        }
        if (this.alreadyHasProposal(proposals, warningToken)) {
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        ASTNode target = node;
        int relevance = -2;
        while ((relevance = this.addSuppressWarningsProposalIfPossible(context, target, warningToken, relevance, proposals)) != 0 && (target = target.getParent()) != null) {
        }
        if (target == null && (importStatement = ASTNodes.getParent(node, ImportDeclaration.class)) != null && !context.getASTRoot().types().isEmpty() && (target = (ASTNode)context.getASTRoot().types().get(0)) != null) {
            this.addSuppressWarningsProposalIfPossible(context, target, warningToken, -2, proposals);
        }
        this.addAllSuppressWarningsProposalIfPossible(context, target, warningToken, -3, proposals);
    }

    private int addSuppressWarningsProposalIfPossible(IInvocationContext context, ASTNode node, String warningToken, int relevance, Collection<T> proposals) {
        Object name;
        ChildListPropertyDescriptor property;
        boolean isLocalVariable = false;
        switch (node.getNodeType()) {
            case 44: {
                if (node.getParent() instanceof PatternInstanceofExpression && warningToken.equals("preview")) {
                    return relevance;
                }
                property = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
                name = ((SingleVariableDeclaration)node).getName().getIdentifier();
                isLocalVariable = true;
                break;
            }
            case 60: {
                property = VariableDeclarationStatement.MODIFIERS2_PROPERTY;
                name = SuppressWarningsBaseSubProcessor.getFirstFragmentName(((VariableDeclarationStatement)node).fragments());
                isLocalVariable = true;
                break;
            }
            case 58: {
                property = VariableDeclarationExpression.MODIFIERS2_PROPERTY;
                name = SuppressWarningsBaseSubProcessor.getFirstFragmentName(((VariableDeclarationExpression)node).fragments());
                isLocalVariable = true;
                break;
            }
            case 55: {
                property = TypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((TypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 103: {
                property = RecordDeclaration.MODIFIERS2_PROPERTY;
                name = ((RecordDeclaration)node).getName().getIdentifier();
                break;
            }
            case 81: {
                property = AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((AnnotationTypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 71: {
                property = EnumDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumDeclaration)node).getName().getIdentifier();
                break;
            }
            case 23: {
                property = FieldDeclaration.MODIFIERS2_PROPERTY;
                name = SuppressWarningsBaseSubProcessor.getFirstFragmentName(((FieldDeclaration)node).fragments());
                break;
            }
            case 31: {
                property = MethodDeclaration.MODIFIERS2_PROPERTY;
                name = ((MethodDeclaration)node).getName().getIdentifier() + "()";
                break;
            }
            case 82: {
                property = AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
                name = ((AnnotationTypeMemberDeclaration)node).getName().getIdentifier() + "()";
                break;
            }
            case 72: {
                property = EnumConstantDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumConstantDeclaration)node).getName().getIdentifier();
                break;
            }
            default: {
                return relevance;
            }
        }
        IProposableFix fix = SuppressWarningsFixCore.createFix(context.getASTRoot(), node, property, warningToken, BasicElementLabels.getJavaElementName((String)name));
        if (fix != null) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_necessary_suppress_warnings", "true");
            SuppressWarningsCleanUp cleanUp = new SuppressWarningsCleanUp(options);
            cleanUp.setWarningToken(warningToken);
            T proposal = this.createSuppressWarningsProposal(fix, cleanUp, -3, context);
            proposals.add(proposal);
        }
        return isLocalVariable ? relevance - 1 : 0;
    }

    private void addAllSuppressWarningsProposalIfPossible(IInvocationContext context, ASTNode node, String warningToken, int relevance, Collection<T> proposals) {
        IProposableFix fix;
        CompilationUnit compilationUnit = (CompilationUnit)node.getRoot();
        IProblem[] problems = compilationUnit.getProblems();
        HashMap<ASTNode, ChildListPropertyDescriptor> nodeMap = new HashMap<ASTNode, ChildListPropertyDescriptor>();
        int i = 0;
        while (i < problems.length) {
            ProblemLocation location = new ProblemLocation(problems[i]);
            if (warningToken.equals(CorrectionEngine.getWarningToken((int)location.getProblemId()))) {
                ASTNode coveringNode;
                ASTNode target = coveringNode = location.getCoveringNode(compilationUnit);
                ChildListPropertyDescriptor property = null;
                while ((property = SuppressWarningsFixCore.getChildListPropertyDescriptor(target, warningToken)) == null && (target = target.getParent()) != null) {
                }
                if (target != null) {
                    nodeMap.put(target, property);
                }
            }
            ++i;
        }
        if (nodeMap.size() > 1 && (fix = SuppressWarningsFixCore.createAllFix(context.getASTRoot(), nodeMap, warningToken)) != null) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_necessary_suppress_warnings", "true");
            SuppressWarningsCleanUp cleanUp = new SuppressWarningsCleanUp(options);
            cleanUp.setWarningToken(warningToken);
            T proposal = this.createSuppressWarningsProposal(fix, cleanUp, relevance - 1, context);
            proposals.add(proposal);
        }
    }

    private static String getFirstFragmentName(List<VariableDeclarationFragment> fragments) {
        if (fragments.size() > 0) {
            return fragments.get(0).getName().getIdentifier();
        }
        return "";
    }

    public void getUnknownSuppressWarningProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode coveringNode = context.getCoveringNode();
        if (!(coveringNode instanceof StringLiteral)) {
            return;
        }
        AST ast = coveringNode.getAST();
        StringLiteral literal = (StringLiteral)coveringNode;
        String literalValue = literal.getLiteralValue();
        String[] stringArray = CorrectionEngine.getAllWarningTokens();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            if (NameMatcher.isSimilarName(literalValue, curr)) {
                StringLiteral newLiteral = ast.newStringLiteral();
                newLiteral.setLiteralValue(curr);
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                rewrite.replace((ASTNode)literal, (ASTNode)newLiteral, null);
                String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_fix_suppress_token_label, new String[]{curr});
                T proposal = this.createASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5);
                proposals.add(proposal);
            }
            ++n2;
        }
        this.getRemoveUnusedSuppressWarningProposals(context, problem, proposals);
    }

    public void getRemoveUnusedSuppressWarningProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        T proposal;
        UnusedSuppressWarningsCleanUp cleanUp;
        Hashtable<String, String> options;
        ASTNode parent;
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        if (!(coveringNode instanceof StringLiteral)) {
            return;
        }
        StringLiteral literal = (StringLiteral)coveringNode;
        if (coveringNode.getParent() instanceof MemberValuePair) {
            coveringNode = coveringNode.getParent();
        }
        if (!((parent = coveringNode.getParent()) instanceof SingleMemberAnnotation || parent instanceof NormalAnnotation || parent instanceof ArrayInitializer)) {
            return;
        }
        IProposableFix fix = UnusedSuppressWarningsFixCore.createFix(context.getASTRoot(), problem);
        if (fix != null) {
            options = new Hashtable<String, String>();
            options.put("cleanup.remove_unnecessary_suppress_warnings", "true");
            cleanUp = new UnusedSuppressWarningsCleanUp(options);
            cleanUp.setLiteral(literal);
            proposal = this.createFixCorrectionProposal(fix, cleanUp, 5, context);
            proposals.add(proposal);
        }
        if ((fix = UnusedSuppressWarningsFixCore.createAllFix(context.getASTRoot(), null)) != null) {
            options = new Hashtable();
            options.put("cleanup.remove_unnecessary_suppress_warnings", "true");
            cleanUp = new UnusedSuppressWarningsCleanUp(options);
            proposal = this.createFixCorrectionProposal(fix, cleanUp, 5, context);
            proposals.add(proposal);
        }
    }

    protected abstract T createSuppressWarningsProposal(IProposableFix var1, ICleanUp var2, int var3, IInvocationContext var4);

    protected abstract T createASTRewriteCorrectionProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);

    protected abstract T createFixCorrectionProposal(IProposableFix var1, ICleanUp var2, int var3, IInvocationContext var4);

    protected abstract boolean alreadyHasProposal(Collection<T> var1, String var2);
}

