/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaCompositorDetails
extends AbstractSchemaDetails {
    private SchemaCompositor fCompositor;
    private ComboPart fKind;
    private Label fKindLabel;

    public SchemaCompositorDetails(ElementSection section) {
        super(section, true, false);
    }

    @Override
    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.createMinOccurComp(parent, toolkit);
        this.createMaxOccurComp(parent, toolkit);
        this.fKindLabel = toolkit.createLabel(parent, PDEUIMessages.SchemaCompositorDetails_type);
        this.fKindLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fKind = new ComboPart();
        this.fKind.createControl(parent, toolkit, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fKind.getControl().setLayoutData((Object)gd);
        this.fKind.setItems(new String[]{ISchemaCompositor.kindTable[1], ISchemaCompositor.kindTable[2]});
        this.fKind.getControl().setEnabled(this.isEditable());
        this.setText(PDEUIMessages.SchemaCompositorDetails_title);
    }

    @Override
    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaCompositor)) {
            return;
        }
        this.fCompositor = (SchemaCompositor)object;
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaCompositorDetails_description, (Object)this.fCompositor.getName()));
        this.updateMinOccur(this.fCompositor.getMinOccurs());
        this.updateMaxOccur(this.fCompositor.getMaxOccurs());
        this.fKind.select(this.fCompositor.getKind() - 1);
        boolean editable = this.isEditableElement();
        this.fKindLabel.setEnabled(editable);
        this.fKind.setEnabled(editable);
        this.enableMinMax(editable);
    }

    @Override
    public void hookListeners() {
        this.hookMinOccur(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fCompositor.setMinOccurs(this.getMinOccur());
        }));
        this.hookMaxOccur(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fCompositor.setMaxOccurs(this.getMaxOccur());
        }));
        this.fKind.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fCompositor.setKind(this.fKind.getSelectionIndex() + 1);
            this.setDecription(NLS.bind((String)PDEUIMessages.SchemaCompositorDetails_description, (Object)this.fCompositor.getName()));
        }));
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

