/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.environments;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.util.NLS;

public final class ExecutionEnvironmentDescription {
    public static final String ENDORSED_DIRS = "-Dee.endorsed.dirs";
    public static final String BOOT_CLASS_PATH = "-Dee.bootclasspath";
    public static final String SOURCE_DEFAULT = "-Dee.src";
    public static final String SOURCE_MAP = "-Dee.src.map";
    public static final String JAVADOC_LOC = "-Dee.javadoc";
    public static final String INDEX_LOC = "-Dee.index";
    public static final String ADDITIONAL_DIRS = "-Dee.additional.dirs";
    public static final String EXTENSION_DIRS = "-Dee.ext.dirs";
    public static final String LANGUAGE_LEVEL = "-Dee.language.level";
    public static final String CLASS_LIB_LEVEL = "-Dee.class.library.level";
    public static final String EXECUTABLE = "-Dee.executable";
    public static final String EXECUTABLE_CONSOLE = "-Dee.executable.console";
    public static final String JAVA_HOME = "-Djava.home";
    public static final String DEBUG_ARGS = "-Dee.debug.args";
    public static final String EE_NAME = "-Dee.name";
    public static final String EE_HOME = "-Dee.home";
    private static final String VAR_EE_HOME = "${ee.home}";
    private static final String EE_ARG_FILTER = "-Dee.";
    private static final Character WILDCARD_SINGLE_CHAR = Character.valueOf('?');
    private static final Character WILDCARD_MULTI_CHAR = Character.valueOf('*');
    private static final String REGEX_SPECIAL_CHARS = "+()^$.{}[]|\\";
    private final Map<String, String> fProperties;

    public ExecutionEnvironmentDescription(File eeFile) throws CoreException {
        this.fProperties = ExecutionEnvironmentDescription.resolveEEHome(ExecutionEnvironmentDescription.loadProperties(eeFile));
    }

    public ExecutionEnvironmentDescription(Map<String, String> eeProperties) {
        this.fProperties = ExecutionEnvironmentDescription.resolveEEHome(new LinkedHashMap<String, String>(eeProperties));
    }

    public Map<String, String> getProperties() {
        return this.fProperties;
    }

    public String getProperty(String property) {
        return this.fProperties.get(property);
    }

    private Optional<String> getEEHomePath() {
        return Optional.ofNullable(this.getProperty(EE_HOME));
    }

    public LibraryLocation[] getLibraryLocations() {
        ArrayList<LibraryLocation> allLibs = new ArrayList<LibraryLocation>();
        String dirs = this.getProperty(ENDORSED_DIRS);
        if (dirs != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(this.resolvePaths(dirs)));
        }
        if ((dirs = this.getProperty(BOOT_CLASS_PATH)) != null) {
            String[] bootpath = this.resolvePaths(dirs);
            ArrayList<LibraryLocation> boot = new ArrayList<LibraryLocation>(bootpath.length);
            IPath src = this.getSourceLocation();
            URL url = this.getJavadocLocation();
            URL indexurl = this.getIndexLocation();
            int i = 0;
            while (i < bootpath.length) {
                IPath path = IPath.fromOSString((String)bootpath[i]);
                File lib2 = path.toFile();
                if (lib2.exists() && lib2.isFile()) {
                    LibraryLocation libraryLocation = new LibraryLocation(path, src, IPath.EMPTY, url, indexurl);
                    boot.add(libraryLocation);
                }
                ++i;
            }
            allLibs.addAll(boot);
        }
        if ((dirs = this.getProperty(ADDITIONAL_DIRS)) != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(this.resolvePaths(dirs)));
        }
        if ((dirs = this.getProperty(EXTENSION_DIRS)) != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(this.resolvePaths(dirs)));
        }
        HashSet set = new HashSet();
        allLibs.removeIf(lib -> !set.add(lib.getSystemLibraryPath().toOSString()));
        this.addSourceLocationsToLibraries(this.getSourceMap(), allLibs);
        return allLibs.toArray(new LibraryLocation[allLibs.size()]);
    }

    public String getVMArguments() {
        StringBuilder arguments = new StringBuilder();
        Optional<String> eeHome = this.getEEHomePath();
        this.fProperties.forEach((key, value) -> {
            boolean appendArgument;
            boolean bl = appendArgument = !key.startsWith(EE_ARG_FILTER);
            if (appendArgument) {
                arguments.append((String)key);
                if (!value.isEmpty()) {
                    arguments.append('=');
                    value = ExecutionEnvironmentDescription.resolveHome(value, eeHome);
                    if (value.indexOf(32) > -1) {
                        arguments.append('\"').append((String)value).append('\"');
                    } else {
                        arguments.append((String)value);
                    }
                }
                arguments.append(' ');
            }
        });
        if (arguments.charAt(arguments.length() - 1) == ' ') {
            arguments.deleteCharAt(arguments.length() - 1);
        }
        return arguments.toString();
    }

    public File getExecutable() {
        String[] paths;
        String property = this.getProperty(EXECUTABLE);
        if (property != null && (paths = this.resolvePaths(property)).length == 1) {
            return new File(paths[0]);
        }
        return null;
    }

    public File getConsoleExecutable() {
        String[] paths;
        String property = this.getProperty(EXECUTABLE_CONSOLE);
        if (property != null && (paths = this.resolvePaths(property)).length == 1) {
            return new File(paths[0]);
        }
        return null;
    }

    private static Map<String, String> loadProperties(File eeFile) throws CoreException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<String> lines = Files.lines(eeFile.toPath(), Charset.defaultCharset());){
                lines.filter(l -> !l.startsWith("#") && !l.isBlank()).forEach(line -> {
                    int eq = line.indexOf(61);
                    if (eq > 0) {
                        String key = line.substring(0, eq);
                        String value = null;
                        if (line.length() > eq + 1) {
                            value = line.substring(eq + 1).trim();
                        }
                        properties.put(key, value);
                    } else {
                        properties.put((String)line, "");
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)LaunchingMessages.ExecutionEnvironmentDescription_1, (Object[])new String[]{eeFile.getPath()}), (Throwable)e));
        }
        properties.putIfAbsent(EE_HOME, eeFile.getParentFile().getAbsolutePath());
        return properties;
    }

    private static Map<String, String> resolveEEHome(Map<String, String> eeProperties) {
        Optional<String> eeHome = Optional.ofNullable(eeProperties.get(EE_HOME));
        eeProperties.replaceAll((k, value) -> value != null ? ExecutionEnvironmentDescription.resolveHome(value, eeHome) : "");
        return eeProperties;
    }

    private static String resolveHome(String value, Optional<String> eeHome) {
        int start = 0;
        int index = value.indexOf(VAR_EE_HOME, start);
        StringBuilder replaced = null;
        while (index >= 0) {
            if (replaced == null) {
                replaced = new StringBuilder();
            }
            replaced.append(value.substring(start, index));
            replaced.append(eeHome.orElseThrow());
            start = index + VAR_EE_HOME.length();
            index = value.indexOf(VAR_EE_HOME, start);
        }
        if (replaced != null) {
            replaced.append(value.substring(start));
            return replaced.toString();
        }
        return value;
    }

    private String[] resolvePaths(String paths) {
        String[] strings = paths.split(File.pathSeparator, -1);
        Optional<String> root = this.getEEHomePath();
        int i = 0;
        while (i < strings.length) {
            strings[i] = this.makePathAbsolute(strings[i], root);
            ++i;
        }
        return strings;
    }

    private String makePathAbsolute(String pathString, Optional<String> root) {
        IPath path = IPath.fromOSString((String)pathString.trim());
        if (!path.isEmpty() && !path.isAbsolute()) {
            IPath filePath = IPath.fromOSString((String)root.orElseThrow()).append(path);
            return filePath.toOSString();
        }
        return path.toOSString();
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, String> getSourceMap() {
        block13: {
            srcMapString = this.getProperty("-Dee.src.map");
            srcMap = new HashMap<String, String>();
            if (srcMapString == null) break block13;
            entries = srcMapString.split(File.pathSeparator);
            i = 0;
            while (i < entries.length) {
                block15: {
                    block14: {
                        index = entries[i].indexOf(61);
                        if (index <= 0 || index >= entries[i].length() - 1) break block14;
                        root = this.getEEHomePath();
                        key = entries[i].substring(0, index);
                        value = entries[i].substring(index + 1);
                        key = this.makePathAbsolute(key, root);
                        value = this.makePathAbsolute(value, root);
                        wildcards = new ArrayList<Character>();
                        keyBuffer = new StringBuilder();
                        chars = key.toCharArray();
                        j = 0;
                        while (j < chars.length) {
                            if (chars[j] == ExecutionEnvironmentDescription.WILDCARD_MULTI_CHAR.charValue()) {
                                wildcards.add(ExecutionEnvironmentDescription.WILDCARD_MULTI_CHAR);
                                keyBuffer.append("(.*)");
                            } else if (chars[j] == ExecutionEnvironmentDescription.WILDCARD_SINGLE_CHAR.charValue()) {
                                wildcards.add(ExecutionEnvironmentDescription.WILDCARD_SINGLE_CHAR);
                                keyBuffer.append("(.)");
                            } else if ("+()^$.{}[]|\\".indexOf(chars[j]) != -1) {
                                keyBuffer.append('\\').append(chars[j]);
                            } else {
                                keyBuffer.append(chars[j]);
                            }
                            ++j;
                        }
                        currentWild = 0;
                        valueBuffer = new StringBuilder();
                        chars = value.toCharArray();
                        j = 0;
                        while (j < chars.length) {
                            if (chars[j] != ExecutionEnvironmentDescription.WILDCARD_MULTI_CHAR.charValue() && chars[j] != ExecutionEnvironmentDescription.WILDCARD_SINGLE_CHAR.charValue()) ** GOTO lbl56
                            if (currentWild >= wildcards.size()) ** GOTO lbl54
                            wild = (Character)wildcards.get(currentWild);
                            if (chars[j] == wild.charValue()) {
                                valueBuffer.append('$').append(currentWild + 1);
                                ++currentWild;
                            } else {
                                LaunchingPlugin.log(NLS.bind((String)LaunchingMessages.EEVMType_5, (Object[])new String[]{entries[i]}));
                                break;
lbl54:
                                // 1 sources

                                LaunchingPlugin.log(NLS.bind((String)LaunchingMessages.EEVMType_5, (Object[])new String[]{entries[i]}));
                                break;
lbl56:
                                // 1 sources

                                if ("+()^$.{}[]|\\".indexOf(chars[j]) != -1) {
                                    valueBuffer.append('\\').append(chars[j]);
                                } else {
                                    valueBuffer.append(chars[j]);
                                }
                            }
                            ++j;
                        }
                        srcMap.put(keyBuffer.toString(), valueBuffer.toString());
                        break block15;
                    }
                    LaunchingPlugin.log(NLS.bind((String)LaunchingMessages.EEVMType_6, (Object[])new String[]{entries[i]}));
                }
                ++i;
            }
        }
        return srcMap;
    }

    private void addSourceLocationsToLibraries(Map<String, String> srcMap, List<LibraryLocation> libraries) {
        srcMap.forEach((currentKey, value) -> {
            Pattern currentPattern = Pattern.compile(currentKey);
            Matcher matcher = currentPattern.matcher("");
            for (LibraryLocation currentLibrary : libraries) {
                String sourceLocation;
                IPath sourcePath;
                matcher.reset(currentLibrary.getSystemLibraryPath().toOSString());
                if (!matcher.find() || !(sourcePath = IPath.fromOSString((String)(sourceLocation = matcher.replaceAll((String)value)))).toFile().exists()) continue;
                currentLibrary.setSystemLibrarySource(sourcePath);
            }
        });
    }

    private IPath getSourceLocation() {
        String src = this.getProperty(SOURCE_DEFAULT);
        if (src != null) {
            Optional<String> eeHome = this.getEEHomePath();
            src = this.makePathAbsolute(src, eeHome);
            return IPath.fromOSString((String)src);
        }
        return IPath.EMPTY;
    }

    private URL getJavadocLocation() {
        return EEVMType.getJavadocLocation(this);
    }

    private URL getIndexLocation() {
        return EEVMType.getIndexLocation(this);
    }
}

