/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.ant.internal.core.AntClassLoader;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class AntRunner
implements IApplication {
    private static boolean buildRunning = false;
    protected String buildFileLocation = "build.xml";
    protected List<String> buildListeners;
    protected String[] targets;
    protected Map<String, String> userProperties;
    protected int messageOutputLevel = 2;
    protected String buildLoggerClassName;
    protected String inputHandlerClassName;
    protected String[] arguments;
    protected String[] propertyFiles;
    protected URL[] customClasspath;
    protected String antHome;
    private IProgressMonitor progressMonitor = null;

    public void setBuildFileLocation(String buildFileLocation) {
        this.buildFileLocation = buildFileLocation == null ? "build.xml" : buildFileLocation;
    }

    public void setMessageOutputLevel(int level) {
        this.messageOutputLevel = level;
    }

    public void setArguments(String arguments) {
        this.arguments = this.getArray(arguments);
    }

    private String[] getArray(String args) {
        StringBuilder sb = new StringBuilder();
        boolean waitingForQuote = false;
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(args, ", \"", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (waitingForQuote) {
                if (token.equals("\"")) {
                    result.add(sb.toString());
                    sb.setLength(0);
                    waitingForQuote = false;
                    continue;
                }
                sb.append(token);
                continue;
            }
            if (token.equals("\"")) {
                int index;
                String last;
                if (!result.isEmpty() && (last = (String)result.get(index = result.size() - 1)).charAt(last.length() - 1) == '=') {
                    result.remove(index);
                    sb.append(last);
                }
                waitingForQuote = true;
                continue;
            }
            if (token.equals(",") || token.equals(" ")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setExecutionTargets(String[] executionTargets) {
        this.targets = executionTargets;
    }

    public void addBuildListener(String className) {
        if (className == null) {
            return;
        }
        if (this.buildListeners == null) {
            this.buildListeners = new ArrayList<String>(5);
        }
        this.buildListeners.add(className);
    }

    public void addBuildLogger(String className) {
        this.buildLoggerClassName = className;
    }

    public void addUserProperties(Map<String, String> properties) {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, String>(properties);
        } else {
            this.userProperties.putAll(properties);
        }
    }

    public synchronized TargetInfo[] getAvailableTargets() throws CoreException {
        Class<?> classInternalAntRunner = null;
        Object runner = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            classInternalAntRunner = this.getInternalAntRunner();
            runner = classInternalAntRunner.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.basicConfigure(classInternalAntRunner, runner);
            Method getTargets = classInternalAntRunner.getMethod("getTargets", new Class[0]);
            Object results = getTargets.invoke(runner, new Object[0]);
            List infos = (List)results;
            TargetInfo[] targetInfo = new TargetInfo[infos.size()];
            int i = 0;
            for (Object target : infos) {
                targetInfo[i++] = (TargetInfo)target;
            }
            TargetInfo[] targetInfoArray = targetInfo;
            return targetInfoArray;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.problemLoadingClass(e);
            TargetInfo[] targetInfoArray = new TargetInfo[]{};
            return targetInfoArray;
        }
        catch (InvocationTargetException e) {
            this.handleInvocationTargetException(runner, classInternalAntRunner, e);
            TargetInfo[] targetInfoArray = new TargetInfo[]{};
            return targetInfoArray;
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : e.getMessage();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.core", 1, message, (Throwable)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void basicConfigure(Class<?> classInternalAntRunner, Object runner) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setBuildFileLocation = classInternalAntRunner.getMethod("setBuildFileLocation", String.class);
        setBuildFileLocation.invoke(runner, this.buildFileLocation);
        if (this.antHome != null) {
            Method setAntHome = classInternalAntRunner.getMethod("setAntHome", String.class);
            setAntHome.invoke(runner, this.antHome);
        }
        this.setProperties(runner, classInternalAntRunner);
        if (this.arguments != null && this.arguments.length > 0) {
            Method setArguments = classInternalAntRunner.getMethod("setArguments", String[].class);
            setArguments.invoke(runner, new Object[]{this.arguments});
        }
    }

    /*
     * Loose catch block
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        if (buildRunning) {
            Status status = new Status(4, "org.eclipse.ant.core", 1, NLS.bind((String)InternalCoreAntMessages.AntRunner_Already_in_progess, (Object)this.buildFileLocation), null);
            throw new CoreException((IStatus)status);
        }
        buildRunning = true;
        Object runner = null;
        Class<?> classInternalAntRunner = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                classInternalAntRunner = this.getInternalAntRunner();
                runner = classInternalAntRunner.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method setBuildFileLocation = classInternalAntRunner.getMethod("setBuildFileLocation", String.class);
                setBuildFileLocation.invoke(runner, this.buildFileLocation);
                if (this.customClasspath != null) {
                    Method setCustomClasspath = classInternalAntRunner.getMethod("setCustomClasspath", URL[].class);
                    setCustomClasspath.invoke(runner, new Object[]{this.customClasspath});
                }
                if (this.buildListeners != null) {
                    Method addBuildListeners = classInternalAntRunner.getMethod("addBuildListeners", List.class);
                    addBuildListeners.invoke(runner, this.buildListeners);
                }
                if (this.buildLoggerClassName == null) {
                    this.buildLoggerClassName = "";
                }
                Method addBuildLogger = classInternalAntRunner.getMethod("addBuildLogger", String.class);
                addBuildLogger.invoke(runner, this.buildLoggerClassName);
                if (this.inputHandlerClassName != null) {
                    Method setInputHandler = classInternalAntRunner.getMethod("setInputHandler", String.class);
                    setInputHandler.invoke(runner, this.inputHandlerClassName);
                }
                this.basicConfigure(classInternalAntRunner, runner);
                if (monitor != null) {
                    this.progressMonitor = monitor;
                    Method setProgressMonitor = classInternalAntRunner.getMethod("setProgressMonitor", IProgressMonitor.class);
                    setProgressMonitor.invoke(runner, monitor);
                }
                if (this.messageOutputLevel != 2) {
                    Method setMessageOutputLevel = classInternalAntRunner.getMethod("setMessageOutputLevel", Integer.TYPE);
                    setMessageOutputLevel.invoke(runner, this.messageOutputLevel);
                }
                if (this.targets != null) {
                    Method setExecutionTargets = classInternalAntRunner.getMethod("setExecutionTargets", String[].class);
                    setExecutionTargets.invoke(runner, new Object[]{this.targets});
                }
                Method run = classInternalAntRunner.getMethod("run", new Class[0]);
                run.invoke(runner, new Object[0]);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.problemLoadingClass(e);
                buildRunning = false;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            catch (InvocationTargetException e) {
                this.handleInvocationTargetException(runner, classInternalAntRunner, e);
                buildRunning = false;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            catch (Exception e) {
                String message = e.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : e.getMessage();
                Status status = new Status(4, "org.eclipse.ant.core", 1, message, (Throwable)e);
                throw new CoreException((IStatus)status);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            buildRunning = false;
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Class<?> getInternalAntRunner() throws ClassNotFoundException {
        ClassLoader loader = this.getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        return loader.loadClass("org.eclipse.ant.internal.core.ant.InternalAntRunner");
    }

    private void setProperties(Object runner, Class<?> classInternalAntRunner) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.userProperties != null) {
            Method addUserProperties = classInternalAntRunner.getMethod("addUserProperties", Map.class);
            addUserProperties.invoke(runner, this.userProperties);
        }
        if (this.propertyFiles != null) {
            Method addPropertyFiles = classInternalAntRunner.getMethod("addPropertyFiles", String[].class);
            addPropertyFiles.invoke(runner, new Object[]{this.propertyFiles});
        }
    }

    protected void handleInvocationTargetException(Object runner, Class<?> classInternalAntRunner, InvocationTargetException e) throws CoreException {
        Throwable realException = e.getTargetException();
        if (realException instanceof OperationCanceledException) {
            return;
        }
        String message = null;
        if (runner != null) {
            try {
                Method getBuildErrorMessage = classInternalAntRunner.getMethod("getBuildExceptionErrorMessage", Throwable.class);
                message = (String)getBuildErrorMessage.invoke(runner, realException);
            }
            catch (Exception getBuildErrorMessage) {
                // empty catch block
            }
        }
        if (message == null && (realException instanceof NoClassDefFoundError || realException instanceof ClassNotFoundException)) {
            this.problemLoadingClass(realException);
            return;
        }
        boolean internalError = false;
        if (message == null) {
            internalError = true;
            message = realException.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : realException.getMessage();
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, realException);
        if (internalError) {
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
        throw new CoreException((IStatus)status);
    }

    protected void problemLoadingClass(Throwable e) throws CoreException {
        String message;
        String missingClassName = e.getMessage();
        if (missingClassName != null) {
            missingClassName = missingClassName.replace('/', '.');
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__2;
            message = NLS.bind((String)message, (Object)missingClassName);
        } else {
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__1;
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, e);
        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    public void run() throws CoreException {
        this.run(null);
    }

    public Object run(Object argArray) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            AntCorePlugin.getPlugin().setRunningHeadless(true);
            if (Platform.inDebugMode()) {
                String[] args = argArray;
                String[] newArgs = new String[args.length + 1];
                System.arraycopy(argArray, 0, newArgs, 0, args.length);
                newArgs[args.length] = "-debug";
                argArray = newArgs;
            }
            ClassLoader loader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> classInternalAntRunner = loader.loadClass("org.eclipse.ant.internal.core.ant.InternalAntRunner");
            Object runner = classInternalAntRunner.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method run = classInternalAntRunner.getMethod("run", Object.class);
            run.invoke(runner, new Object[]{argArray});
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return EXIT_OK;
    }

    private ClassLoader getClassLoader() {
        if (this.customClasspath == null) {
            return AntCorePlugin.getPlugin().getNewClassLoader();
        }
        AntCorePreferences preferences = AntCorePlugin.getPlugin().getPreferences();
        ArrayList<URL> fullClasspath = new ArrayList<URL>();
        fullClasspath.addAll(Arrays.asList(this.customClasspath));
        fullClasspath.addAll(Arrays.asList(preferences.getExtraClasspathURLs()));
        return new AntClassLoader(fullClasspath.toArray(new URL[fullClasspath.size()]), preferences.getPluginClassLoaders());
    }

    public void setInputHandler(String className) {
        this.inputHandlerClassName = className;
    }

    public void setPropertyFiles(String[] propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public void setCustomClasspath(URL[] customClasspath) {
        this.customClasspath = customClasspath;
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    public static boolean isBuildRunning() {
        return buildRunning;
    }

    public Object start(IApplicationContext context) throws Exception {
        context.applicationRunning();
        Map contextArguments = context.getArguments();
        return this.run(contextArguments.get("application.args"));
    }

    public void stop() {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(true);
        }
    }
}

