/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.PrimitiveRatherThanWrapperFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class PrimitiveRatherThanWrapperCleanUpCore
extends AbstractCleanUp {
    public PrimitiveRatherThanWrapperCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PrimitiveRatherThanWrapperCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.primitive_rather_than_wrapper");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            return null;
        }
        return PrimitiveRatherThanWrapperFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            return new String[]{MultiFixMessages.PrimitiveRatherThanWrapperCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("boolean aBoolean = Boolean.TRUE;\n");
        } else {
            bld.append("Boolean aBoolean = Boolean.TRUE;\n");
        }
        bld.append("if (aBoolean) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("char aCharacter = Character.MIN_VALUE;\n");
        } else {
            bld.append("Character aCharacter = Character.MIN_VALUE;\n");
        }
        bld.append("if (aCharacter == 'a') {\n");
        bld.append("    System.out.println(\"A!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("byte aByte = Byte.MIN_VALUE;\n");
        } else {
            bld.append("Byte aByte = Byte.MIN_VALUE;\n");
        }
        bld.append("if (aByte == 0) {\n");
        bld.append("    System.out.println(\"Zero!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("short aShort = Short.MIN_VALUE;\n");
        } else {
            bld.append("Short aShort = Short.MIN_VALUE;\n");
        }
        bld.append("if (aShort > i) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("int anInteger = Integer.MIN_VALUE;\n");
        } else {
            bld.append("Integer anInteger = Integer.MIN_VALUE;\n");
        }
        bld.append("if (anInteger > i) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("long aLong = Long.MIN_VALUE;\n");
        } else {
            bld.append("Long aLong = Long.MIN_VALUE;\n");
        }
        bld.append("if (aLong > i) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("float aFloat = Float.MIN_VALUE;\n");
        } else {
            bld.append("Float aFloat = Float.MIN_VALUE;\n");
        }
        bld.append("if (aFloat > 0.0f) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        if (this.isEnabled("cleanup.primitive_rather_than_wrapper")) {
            bld.append("double aDouble = Double.MIN_VALUE;\n");
        } else {
            bld.append("Double aDouble = Double.MIN_VALUE;\n");
        }
        bld.append("if (aDouble > 0.0) {\n");
        bld.append("    System.out.println(\"True!\");\n");
        bld.append("}\n");
        return bld.toString();
    }
}

