/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.refactoring.util.AbstractChecker;

public class ChangedValueChecker
extends AbstractChecker {
    private ASTNode fNode2;
    private Set<Elem> fDependSet;
    private ASTNode fBodyNode;
    private static final int THRESHOLD = 2500;
    private ArrayList<ASTNode> fMiddleNodes;
    private volatile boolean fConflict;
    private Set<AbstractChecker.Position> fPosSet;
    private String fEnclosingMethodSignature;
    private ASTNode fAssignmentExpressionToIgnore;

    public ChangedValueChecker(ASTNode selectedExpression, String enclosingMethodSignature) {
        this.fEnclosingMethodSignature = enclosingMethodSignature;
        this.analyzeSelectedExpression(selectedExpression);
    }

    public ChangedValueChecker(ASTNode selectedExpression, String enclosingMethodSignature, boolean ignoreAssignmentUpdates) {
        this.fEnclosingMethodSignature = enclosingMethodSignature;
        this.fAssignmentExpressionToIgnore = ignoreAssignmentUpdates ? selectedExpression : null;
        this.analyzeSelectedExpression(selectedExpression);
    }

    public void detectConflict(int startOffset, int endOffset, ASTNode node, ASTNode bodyNode, ArrayList<IASTFragment> candidateList) {
        this.fNode2 = node;
        this.fBodyNode = bodyNode;
        this.fConflict = false;
        this.fPosSet = ConcurrentHashMap.newKeySet();
        PathVisitor pathVisitor = new PathVisitor(startOffset, endOffset, this.fNode2, candidateList);
        while (this.fBodyNode != null && (this.fBodyNode.getStartPosition() + this.fBodyNode.getLength() < pathVisitor.endOffset || this.fBodyNode.getStartPosition() > pathVisitor.startOffset)) {
            this.fBodyNode = this.fBodyNode.getParent();
        }
        if (this.fBodyNode != null) {
            this.fBodyNode.accept((ASTVisitor)pathVisitor);
        }
        this.fMiddleNodes = pathVisitor.nodes;
    }

    public void analyzeSelectedExpression(ASTNode selectedExpression) {
        this.fDependSet = ConcurrentHashMap.newKeySet();
        ReadVisitor readVisitor = new ReadVisitor(true);
        selectedExpression.accept((ASTVisitor)readVisitor);
        this.fDependSet.addAll(readVisitor.readSet);
    }

    public boolean hasConflict() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ThreadPoolExecutor threadPool = new ThreadPoolExecutor(5, 10, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());){
            block17: {
                try {
                    try {
                        for (ASTNode node : this.fMiddleNodes) {
                            if (this.fConflict) break;
                            AbstractChecker.Position pos = new AbstractChecker.Position(node.getStartPosition(), node.getLength());
                            if (!this.fPosSet.add(pos)) continue;
                            threadPool.execute(() -> {
                                UpdateVisitor uv = new UpdateVisitor(this.fDependSet, true, (Expression)this.fAssignmentExpressionToIgnore);
                                System.out.println(node);
                                node.accept((ASTVisitor)uv);
                                if (uv.hasConflict()) {
                                    this.fConflict = true;
                                }
                            });
                        }
                        if (!this.fConflict) {
                            threadPool.shutdown();
                            while (!threadPool.isTerminated() && !this.fConflict) {
                                threadPool.awaitTermination(10L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        threadPool.shutdownNow();
                        break block17;
                    }
                }
                catch (Throwable throwable2) {
                    threadPool.shutdownNow();
                    throw throwable2;
                }
                threadPool.shutdownNow();
            }
            return this.fConflict;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected void search(SearchPattern searchPattern, IJavaSearchScope scope, SearchRequestor requestor) throws CoreException {
        new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MethodDeclaration findFunctionDefinition(ITypeBinding iTypeBinding, IMethodBinding methodBinding) {
        if (methodBinding == null) return null;
        if (iTypeBinding == null) {
            return null;
        }
        if (!(iTypeBinding.getJavaElement() instanceof IType)) {
            return null;
        }
        IType it = (IType)iTypeBinding.getJavaElement();
        try {
            MethodDeclaration md;
            IType resultType;
            ICompilationUnit icu;
            SearchMatch result;
            Object obj;
            IClasspathEntry cpEntry;
            IJavaElement root = it.getAncestor(3);
            if (root instanceof IPackageFragmentRoot && (cpEntry = ((IPackageFragmentRoot)root).getRawClasspathEntry()).getEntryKind() == 5 && cpEntry.getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                return null;
            }
            IMethod iMethod = (IMethod)methodBinding.getJavaElement();
            if (iMethod == null) {
                return null;
            }
            IType type = iMethod.getDeclaringType();
            if (type == null) {
                return null;
            }
            if (!type.isInterface()) {
                ICompilationUnit icu2 = iMethod.getCompilationUnit();
                if (icu2 == null) return null;
                if (icu2.getSource() != null) return this.getMethodDeclaration(iMethod, icu2);
                return null;
            }
            String typeName = type.getFullyQualifiedName();
            SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)1, (int)8);
            FunctionSearchRequestor requestor = new FunctionSearchRequestor();
            try {
                this.search(pattern, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMethod.getJavaProject()}), requestor);
            }
            catch (CoreException e) {
                return null;
            }
            List<SearchMatch> results = requestor.getResults();
            Iterator<SearchMatch> iterator = results.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!((obj = (result = iterator.next()).getElement()) instanceof IType) || (icu = (resultType = (IType)obj).getCompilationUnit()) == null || icu.getSource() == null || (md = this.getMethodDeclaration(iMethod, icu)) == null);
            return md;
        }
        catch (OperationCanceledException | JavaModelException throwable) {
            // empty catch block
        }
        return null;
    }

    private MethodDeclaration getMethodDeclaration(IMethod iMethod, ICompilationUnit icu) throws JavaModelException {
        MethodDeclaration md;
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(8);
        parser.setSource(icu);
        parser.setResolveBindings(true);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        ASTNode perform = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)iMethod.getSourceRange());
        if (perform instanceof MethodDeclaration && ((MethodDeclaration)perform).resolveBinding() != null && !Modifier.isAbstract((int)(md = (MethodDeclaration)perform).resolveBinding().getModifiers())) {
            return md;
        }
        return null;
    }

    private ASTNode getOriginalExpression(ASTNode node) {
        while (node != null) {
            if (node instanceof ParenthesizedExpression) {
                ParenthesizedExpression pe = (ParenthesizedExpression)node;
                node = pe.getExpression();
                continue;
            }
            if (!(node instanceof CastExpression)) break;
            CastExpression ce = (CastExpression)node;
            node = ce.getExpression();
        }
        return node;
    }

    class Elem {
        Object memberKey;
        Elem e;

        public Elem(ASTNode node, boolean flag) {
            if (node instanceof SimpleName) {
                SimpleName sn = (SimpleName)node;
                IBinding resolveBinding = sn.resolveBinding();
                if (resolveBinding != null && resolveBinding.getJavaElement() != null && (resolveBinding.getJavaElement().getElementType() != 14 || flag)) {
                    this.memberKey = resolveBinding.getKey();
                }
            } else if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                SimpleName sn = qn.getName();
                Object object = this.memberKey = sn.resolveBinding() != null ? sn.resolveBinding().getKey() : null;
                if (qn.resolveBinding() != null && qn.resolveBinding().getModifiers() != 8) {
                    this.e = new Elem((ASTNode)qn.getQualifier(), flag);
                }
            } else if (node instanceof FieldAccess) {
                FieldAccess fa = (FieldAccess)node;
                SimpleName sn = fa.getName();
                this.memberKey = sn.resolveBinding() != null ? sn.resolveBinding().getKey() : null;
                ASTNode expr = ChangedValueChecker.this.getOriginalExpression((ASTNode)fa.getExpression());
                if (expr instanceof MethodInvocation) {
                    if (flag) {
                        this.e = new Elem((MethodInvocation)expr);
                    } else {
                        this.memberKey = null;
                    }
                } else {
                    this.e = new Elem(expr, flag);
                }
            } else if (node instanceof MethodInvocation) {
                MethodInvocation mi = (MethodInvocation)node;
                if (flag) {
                    this.e = new Elem(mi);
                } else {
                    this.memberKey = null;
                }
            }
        }

        public Elem(MethodInvocation expr) {
            this.memberKey = expr.toString();
        }

        public Elem(ASTNode node, boolean flag, Elem e) {
            if (node instanceof MethodInvocation && flag) {
                MethodInvocation mi = (MethodInvocation)node;
                this.e = new Elem((ASTNode)mi.getExpression(), flag);
                this.memberKey = e;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + this.toString().hashCode();
            return result;
        }

        public String toString() {
            String str1 = this.e == null ? "" : this.e.toString();
            String str2 = "";
            if (this.memberKey instanceof String) {
                str2 = (String)this.memberKey;
            } else if (this.memberKey instanceof Elem) {
                str2 = ((Elem)this.memberKey).toString();
            }
            if (!str1.equals("")) {
                return str1 + str2;
            }
            return str2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Elem)) {
                return false;
            }
            Elem other = (Elem)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            String str1 = this.toString();
            String str2 = obj.toString();
            return str1.equals(str2);
        }

        private ChangedValueChecker getEnclosingInstance() {
            return ChangedValueChecker.this;
        }
    }

    private class FunctionSearchRequestor
    extends SearchRequestor {
        public List<SearchMatch> results = new ArrayList<SearchMatch>();

        private FunctionSearchRequestor() {
        }

        public List<SearchMatch> getResults() {
            return this.results;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() == 0) {
                this.results.add(match);
            }
        }
    }

    class PathVisitor
    extends ASTVisitor {
        ArrayList<ASTNode> nodes = new ArrayList();
        ArrayList<IASTFragment> candidateList;
        HashSet<AbstractChecker.Position> posSet = new HashSet();
        int startOffset;
        int endOffset;
        TraversalStatus state;
        ASTNode selectedExpression;

        public PathVisitor(int startOffset, int endOffset, ASTNode node, ArrayList<IASTFragment> candidateList) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.selectedExpression = node;
            this.candidateList = candidateList;
            this.state = TraversalStatus.NOT_YET_BETWEEN_EXPRESSIONS;
            this.extend2EndOfLoop(this.selectedExpression);
        }

        private void extend2EndOfLoop(ASTNode node) {
            ASTNode temp = node;
            while (temp != null && !(temp instanceof MethodDeclaration)) {
                if (temp instanceof EnhancedForStatement || temp instanceof WhileStatement || temp instanceof ForStatement || temp instanceof DoStatement) {
                    boolean cond2;
                    int offset = temp.getStartPosition();
                    int length = temp.getLength();
                    int newEndOffset = offset + length;
                    boolean cond1 = offset < this.startOffset && newEndOffset > this.startOffset;
                    boolean bl = cond2 = offset <= this.endOffset && newEndOffset >= this.endOffset;
                    if (!cond1 && cond2) {
                        this.endOffset = newEndOffset;
                    }
                }
                temp = temp.getParent();
            }
        }

        public boolean preVisit2(ASTNode node) {
            if (this.state == TraversalStatus.NOT_YET_BETWEEN_EXPRESSIONS && node.getStartPosition() >= this.startOffset && node.getStartPosition() + node.getLength() <= this.endOffset) {
                this.state = TraversalStatus.BETWEEN_EXPRESSIONS;
            } else if (this.state == TraversalStatus.BETWEEN_EXPRESSIONS && node.getStartPosition() > this.endOffset) {
                this.state = TraversalStatus.EXITED_BETWEEN_EXPRESSIONS;
            }
            if (this.state != TraversalStatus.BETWEEN_EXPRESSIONS) {
                return super.preVisit2(node);
            }
            if (node instanceof Statement && node.getParent() instanceof IfStatement) {
                IfStatement is = (IfStatement)node.getParent();
                if (node.getLocationInParent() == IfStatement.THEN_STATEMENT_PROPERTY && is.getElseStatement() != null && ASTNodes.isParent(this.selectedExpression, (ASTNode)is.getElseStatement())) {
                    int offset = is.getThenStatement().getStartPosition();
                    int length = is.getThenStatement().getLength();
                    int i = 0;
                    while (i < this.candidateList.size()) {
                        if (this.candidateList.get(i).getStartPosition() >= offset && this.candidateList.get(i).getStartPosition() <= offset + length) {
                            while (i < this.candidateList.size() - 1 && this.candidateList.get(1 + i).getStartPosition() >= offset && this.candidateList.get(1 + i).getStartPosition() <= offset + length) {
                                ++i;
                            }
                            if (i >= this.candidateList.size()) break;
                            PathVisitor pv = new PathVisitor(offset, this.candidateList.get(i).getStartPosition(), this.candidateList.get(i).getAssociatedNode(), this.candidateList);
                            is.getThenStatement().accept((ASTVisitor)pv);
                            this.nodes.addAll(pv.nodes);
                            this.posSet.addAll(pv.posSet);
                            break;
                        }
                        ++i;
                    }
                    return false;
                }
            }
            if (node.getStartPosition() >= this.startOffset && node.getStartPosition() + node.getLength() <= this.endOffset) {
                if (node instanceof Type || node instanceof NumberLiteral || node instanceof StringLiteral || node instanceof NullLiteral) {
                    return false;
                }
                AbstractChecker.Position pos = new AbstractChecker.Position(node.getStartPosition(), node.getLength());
                if (this.posSet.add(pos)) {
                    this.nodes.add(node);
                }
                return false;
            }
            return super.preVisit2(node);
        }
    }

    class ReadVisitor
    extends ASTVisitor {
        private HashSet<Elem> readSet = new HashSet();
        private boolean visitMethodCall;

        public ReadVisitor(boolean visitMethodCall) {
            this.visitMethodCall = visitMethodCall;
        }

        private void addToList(Elem e) {
            if (e.memberKey == null) {
                return;
            }
            this.readSet.add(e);
        }

        public boolean visit(FieldAccess fieldAccess) {
            Elem e = new Elem((ASTNode)fieldAccess, this.visitMethodCall);
            this.addToList(e);
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            Elem e = new Elem((ASTNode)qualifiedName, this.visitMethodCall);
            this.addToList(e);
            return false;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                Elem e = new Elem((ASTNode)simpleName, this.visitMethodCall);
                this.addToList(e);
            }
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            IMethodBinding resolveMethodBinding = methodInvocation.resolveMethodBinding();
            if (resolveMethodBinding == null) {
                return super.visit(methodInvocation);
            }
            if (!this.visitMethodCall || resolveMethodBinding.getMethodDeclaration() != null && ChangedValueChecker.this.fEnclosingMethodSignature != null && ChangedValueChecker.this.fEnclosingMethodSignature.equals(resolveMethodBinding.getMethodDeclaration().getKey())) {
                return super.visit(methodInvocation);
            }
            MethodDeclaration md = ChangedValueChecker.this.findFunctionDefinition(resolveMethodBinding.getDeclaringClass(), resolveMethodBinding);
            if (md != null && md.getLength() < 2500) {
                ReadVisitor rv = new ReadVisitor(false);
                md.accept((ASTVisitor)rv);
                for (Elem e : rv.readSet) {
                    this.addToList(new Elem((ASTNode)methodInvocation, this.visitMethodCall, e));
                }
            }
            return super.visit(methodInvocation);
        }
    }

    static enum TraversalStatus {
        NOT_YET_BETWEEN_EXPRESSIONS,
        BETWEEN_EXPRESSIONS,
        EXITED_BETWEEN_EXPRESSIONS;

    }

    class UpdateVisitor
    extends ASTVisitor {
        private HashSet<Elem> updateSet = new HashSet();
        private Set<Elem> dependSet;
        private boolean visitMethodCall;
        private Expression ignoreAssignmentToExpression;

        public UpdateVisitor(Set<Elem> dependSet, boolean visitMethodCall, Expression ignoreAssignmentToExpression) {
            this.visitMethodCall = visitMethodCall;
            this.ignoreAssignmentToExpression = ignoreAssignmentToExpression;
            this.dependSet = dependSet;
        }

        private void addToList(Elem e) {
            if (e.memberKey == null) {
                return;
            }
            this.updateSet.add(e);
        }

        private boolean hasConflict() {
            for (Elem e : this.dependSet) {
                if (!this.updateSet.contains(e)) continue;
                return true;
            }
            return false;
        }

        public boolean visit(Assignment assignment) {
            if (this.ignoreAssignmentToExpression != null && assignment.getLeftHandSide().subtreeMatch(new ASTMatcher(), (Object)this.ignoreAssignmentToExpression)) {
                return super.visit(assignment);
            }
            ReadVisitor v = new ReadVisitor(this.visitMethodCall);
            assignment.getLeftHandSide().accept((ASTVisitor)v);
            for (Elem e : v.readSet) {
                this.addToList(e);
            }
            return super.visit(assignment);
        }

        public boolean visit(PrefixExpression prefixExpression) {
            PrefixExpression.Operator op = prefixExpression.getOperator();
            if (op == PrefixExpression.Operator.INCREMENT || op == PrefixExpression.Operator.DECREMENT) {
                ReadVisitor v = new ReadVisitor(this.visitMethodCall);
                prefixExpression.getOperand().accept((ASTVisitor)v);
                for (Elem e : v.readSet) {
                    this.addToList(e);
                }
            }
            return super.visit(prefixExpression);
        }

        public boolean visit(PostfixExpression postfixExpression) {
            PostfixExpression.Operator op = postfixExpression.getOperator();
            if (op == PostfixExpression.Operator.INCREMENT || op == PostfixExpression.Operator.DECREMENT) {
                ReadVisitor v = new ReadVisitor(this.visitMethodCall);
                postfixExpression.getOperand().accept((ASTVisitor)v);
                for (Elem e : v.readSet) {
                    this.addToList(e);
                }
            }
            return super.visit(postfixExpression);
        }

        public boolean visit(MethodInvocation methodInvocation) {
            IMethodBinding resolveMethodBinding = methodInvocation.resolveMethodBinding();
            if (!this.visitMethodCall || resolveMethodBinding.getMethodDeclaration() != null && ChangedValueChecker.this.fEnclosingMethodSignature != null && ChangedValueChecker.this.fEnclosingMethodSignature.equals(resolveMethodBinding.getMethodDeclaration().getKey())) {
                return super.visit(methodInvocation);
            }
            MethodDeclaration md = ChangedValueChecker.this.findFunctionDefinition(resolveMethodBinding.getDeclaringClass(), resolveMethodBinding);
            if (md != null && md.getLength() < 2500) {
                UpdateVisitor uv = new UpdateVisitor(this.dependSet, false, this.ignoreAssignmentToExpression);
                md.accept((ASTVisitor)uv);
                for (Elem e : uv.updateSet) {
                    this.addToList(new Elem((ASTNode)methodInvocation, this.visitMethodCall, e));
                }
            }
            return super.visit(methodInvocation);
        }
    }
}

