/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.launching.IExecutable;

public class TestSuite {
    private int limit = -1;
    private final IProject project;
    private final List<IQ7NamedElement> executables;
    public final Map<IQ7NamedElement, IExecutable[]> executablesMap = Collections.synchronizedMap(new HashMap());
    private boolean opensource = false;

    public TestSuite(IProject project) {
        this.project = project;
        this.executables = new ArrayList<IQ7NamedElement>();
    }

    public void add(ITestCase tcase) {
        if (!this.executables.contains(tcase)) {
            this.executables.add((IQ7NamedElement)tcase);
        }
    }

    public void sort() {
        SortingUtils.sortNamedElements(this.executables);
    }

    public void setLimit(int limit) {
        if (this.limit == -1) {
            this.limit = limit;
        } else {
            if (limit == -1) {
                limit = Integer.MAX_VALUE;
            }
            this.limit = Math.min(limit, this.limit);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<IQ7NamedElement> getScenarios() {
        if (this.limit == -1) {
            return this.executables;
        }
        int to = this.limit;
        if (to > this.executables.size()) {
            to = this.executables.size();
        }
        return new ArrayList<IQ7NamedElement>(this.executables.subList(0, to));
    }

    public boolean isOpensource() {
        return this.opensource;
    }

    public void setOpensource(boolean opensource) {
        this.opensource = opensource;
    }
}

