/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runtime.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DialogSettingsManager {
    private static DialogSettingsManager theInstance;
    private final Map<String, IDialogSettings> settings = new HashMap<String, IDialogSettings>();
    private final Function<Bundle, IDialogSettings> GET_DIALOG_SETTINGS;

    private DialogSettingsManager() {
        Function<Bundle, IDialogSettings> temp = null;
        try {
            Method getDialogSettingsProvider = PlatformUI.class.getMethod("getDialogSettingsProvider", Bundle.class);
            Method getDialogSettings = Class.forName("org.eclipse.jface.dialogs.IDialogSettingsProvider").getMethod("getDialogSettings", new Class[0]);
            temp = bundle -> {
                try {
                    return (IDialogSettings)getDialogSettings.invoke(getDialogSettingsProvider.invoke(null, bundle), new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (temp == null) {
            temp = bundle -> this.settings.get(this.getKey((Bundle)bundle));
        }
        this.GET_DIALOG_SETTINGS = temp;
    }

    public static DialogSettingsManager getInstance() {
        if (theInstance == null) {
            theInstance = new DialogSettingsManager();
        }
        return theInstance;
    }

    public IDialogSettings getSettings(Bundle bundle) {
        return this.GET_DIALOG_SETTINGS.apply(bundle);
    }

    public void addSettings(Bundle bundle, IDialogSettings dialogSettings) {
        this.settings.put(this.getKey(bundle), dialogSettings);
    }

    public void removeSettings(Bundle bundle) {
        this.settings.remove(this.getKey(bundle));
    }

    private String getKey(Bundle bundle) {
        return bundle.getSymbolicName() + ":" + (String)bundle.getHeaders().get("Bundle-Version");
    }
}

