/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.update.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.update.configurator.FeatureEntry;
import org.eclipse.pde.internal.core.update.configurator.Messages;
import org.eclipse.pde.internal.core.update.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class FeatureParser
extends DefaultHandler {
    private static final ILog LOG = ILog.get();
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;

    public FeatureParser() {
        try {
            this.parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE((boolean)true);
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public FeatureEntry parse(URL featureURL) {
        this.feature = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = featureURL.openStream();){
                this.url = featureURL;
                this.parser.parse(new InputSource(in), (DefaultHandler)this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SAXException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this.feature;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("feature".equals(localName)) {
            this.processFeature(attributes);
            throw new SAXException("");
        }
    }

    private void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().isEmpty() || ver == null || ver.trim().isEmpty()) {
            System.out.println(NLS.bind((String)Messages.FeatureParser_IdOrVersionInvalid, (Object[])new String[]{id, ver}));
        } else {
            String os = attributes.getValue("os");
            String ws = attributes.getValue("ws");
            String nl = attributes.getValue("nl");
            String arch = attributes.getValue("arch");
            if (!Utils.isValidEnvironment(os, ws, arch, nl)) {
                return;
            }
            String primary = attributes.getValue("primary");
            boolean isPrimary = "true".equals(primary);
            String application = attributes.getValue("application");
            String plugin = attributes.getValue("plugin");
            this.feature = new FeatureEntry(id, ver, plugin, "", isPrimary, application, null);
            if ("file".equals(this.url.getProtocol())) {
                File f = new File(this.url.getFile().replace('/', File.separatorChar));
                this.feature.setURL("features/" + f.getParentFile().getName() + "/");
            } else {
                this.feature.setURL(Utils.makeAbsolute(Utils.getInstallURL(), this.url).toExternalForm());
            }
        }
    }
}

