/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.debug.core.breakpoints.LambdaLocationLocatorHelper;

public class ValidBreakpointLocationLocator
extends ASTVisitor {
    public static final int LOCATION_NOT_FOUND = 0;
    public static final int LOCATION_LINE = 1;
    public static final int LOCATION_METHOD = 2;
    public static final int LOCATION_FIELD = 3;
    public static final int LOCATION_LAMBDA_METHOD = 4;
    public static boolean LOCATION_METHOD_CLOSE = false;
    private final CompilationUnit fCompilationUnit;
    private final int fLineNumber;
    private final boolean fBindingsResolved;
    private boolean fNeedBindings = false;
    private final boolean fBestMatch;
    private int fLocationType;
    private boolean fLocationFound;
    private boolean fLambdaVisited;
    private String fLambdaMethodName;
    private String fLambdaMethodSignature;
    private String fTypeName;
    private int fLineLocation;
    private int fMemberOffset;
    private int fNodeLength;
    private List<String> fLabels;
    private final int fInputOffset;
    private final int fInputLength;
    private boolean fThroughToggle;

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = lineNumber;
        this.fBindingsResolved = bindingsResolved;
        this.fBestMatch = bestMatch;
        this.fLocationFound = false;
        this.fInputOffset = -1;
        this.fInputLength = -1;
    }

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch, int offset, int end) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = lineNumber;
        this.fBindingsResolved = bindingsResolved;
        this.fBestMatch = bestMatch;
        this.fLocationFound = false;
        this.fInputOffset = offset;
        this.fInputLength = end;
    }

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch, int offset, int end, boolean throughToggle) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = lineNumber;
        this.fBindingsResolved = bindingsResolved;
        this.fBestMatch = bestMatch;
        this.fLocationFound = false;
        this.fInputOffset = offset;
        this.fInputLength = end;
        this.fThroughToggle = throughToggle;
    }

    public boolean isBindingsRequired() {
        return this.fNeedBindings;
    }

    public int getLocationType() {
        return this.fLocationType;
    }

    public String getFullyQualifiedTypeName() {
        return this.fTypeName;
    }

    public String getLambdaMethodName() {
        return this.fLambdaMethodName;
    }

    public String getfLambdaMethodSignature() {
        return this.fLambdaMethodSignature;
    }

    public int getLineLocation() {
        if (this.fLocationType == 0 || this.fLocationType == 2) {
            return -1;
        }
        return this.fLineLocation;
    }

    public int getMemberOffset() {
        return this.fMemberOffset;
    }

    public int getNodeLength() {
        return this.fNodeLength;
    }

    public CompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    private String computeTypeName(ASTNode node) {
        ITypeBinding binding;
        AbstractTypeDeclaration type = null;
        while (!(node instanceof CompilationUnit)) {
            if (node instanceof AbstractTypeDeclaration) {
                type = (AbstractTypeDeclaration)node;
                break;
            }
            node = node.getParent();
        }
        if (type != null && (binding = type.resolveBinding()) != null) {
            return binding.getBinaryName();
        }
        return this.computeTypeName0(node);
    }

    String computeTypeName0(ASTNode node) {
        Object typeName = null;
        while (!(node instanceof CompilationUnit)) {
            if (node instanceof AbstractTypeDeclaration) {
                String identifier = ((AbstractTypeDeclaration)node).getName().getIdentifier();
                typeName = typeName == null ? identifier : identifier + "$" + (String)typeName;
            }
            node = node.getParent();
        }
        PackageDeclaration packageDecl = ((CompilationUnit)node).getPackage();
        Object packageIdentifier = "";
        if (packageDecl != null) {
            Name packageName = packageDecl.getName();
            while (packageName.isQualifiedName()) {
                QualifiedName qualifiedName = (QualifiedName)packageName;
                packageIdentifier = qualifiedName.getName().getIdentifier() + "." + (String)packageIdentifier;
                packageName = qualifiedName.getQualifier();
            }
            packageIdentifier = ((SimpleName)packageName).getIdentifier() + "." + (String)packageIdentifier;
        }
        return (String)packageIdentifier + typeName;
    }

    private boolean visit(ASTNode node, boolean isCode) {
        int inputEndLine;
        int startPosition = node.getStartPosition();
        int startLine = this.lineNumber(startPosition);
        int endLine = this.lineNumber(startPosition + node.getLength() - 1);
        int n = inputEndLine = this.fInputOffset != -1 ? this.lineNumber(this.fInputOffset) : -1;
        if (this.fLambdaVisited || this.fLocationFound && this.fLineNumber != startLine) {
            return false;
        }
        if (endLine < this.fLineNumber) {
            return false;
        }
        if (isCode && this.fLineNumber <= startLine && (inputEndLine == -1 || startLine <= inputEndLine)) {
            this.fLineLocation = startLine;
            this.fLocationFound = true;
            this.fLocationType = 1;
            this.fTypeName = this.computeTypeName(node);
            return false;
        }
        return true;
    }

    private boolean isReplacedByConstantValue(Expression node) {
        switch (node.getNodeType()) {
            case 9: 
            case 13: 
            case 34: 
            case 45: 
            case 102: {
                return true;
            }
            case 40: 
            case 42: {
                return this.isReplacedByConstantValue((Name)node);
            }
            case 22: {
                return this.isReplacedByConstantValue((FieldAccess)node);
            }
            case 47: {
                return this.isReplacedByConstantValue((SuperFieldAccess)node);
            }
            case 27: {
                return this.isReplacedByConstantValue((InfixExpression)node);
            }
            case 38: {
                return this.isReplacedByConstantValue((PrefixExpression)node);
            }
            case 11: {
                return this.isReplacedByConstantValue(((CastExpression)node).getExpression());
            }
        }
        return false;
    }

    private boolean isReplacedByConstantValue(InfixExpression node) {
        if (!this.isReplacedByConstantValue(node.getLeftOperand()) || !this.isReplacedByConstantValue(node.getRightOperand())) {
            return false;
        }
        if (node.hasExtendedOperands()) {
            Iterator iter = node.extendedOperands().iterator();
            while (iter.hasNext()) {
                if (this.isReplacedByConstantValue((Expression)iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReplacedByConstantValue(PrefixExpression node) {
        PrefixExpression.Operator operator = node.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return this.isReplacedByConstantValue(node.getOperand());
        }
        return false;
    }

    private boolean isReplacedByConstantValue(Name node) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        IBinding binding = node.resolveBinding();
        if (binding != null && binding.getKind() == 3) {
            return ((IVariableBinding)binding).getConstantValue() != null;
        }
        return false;
    }

    private boolean isReplacedByConstantValue(FieldAccess node) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        Expression expression = node.getExpression();
        IVariableBinding binding = node.resolveFieldBinding();
        if (binding != null && expression.getNodeType() == 52) {
            return binding.getConstantValue() != null;
        }
        return false;
    }

    private boolean isReplacedByConstantValue(SuperFieldAccess node) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        IVariableBinding binding = node.resolveFieldBinding();
        if (binding != null) {
            return binding.getConstantValue() != null;
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List decls = node.bodyDeclarations();
            for (BodyDeclaration decl : decls) {
                decl.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ArrayAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayCreation node) {
        return this.visit((ASTNode)node, node.getInitializer() == null);
    }

    public boolean visit(ArrayInitializer node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayType node) {
        return false;
    }

    public boolean visit(AssertStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Assignment node) {
        if (this.visit((ASTNode)node, false)) {
            int startLine;
            Expression leftHandSide = node.getLeftHandSide();
            if (leftHandSide instanceof Name && this.fLineNumber < (startLine = this.lineNumber(node.getStartPosition()))) {
                if (this.fBindingsResolved) {
                    IVariableBinding binding = (IVariableBinding)((Name)leftHandSide).resolveBinding();
                    if (binding != null && (!binding.isField() || Modifier.isStatic((int)binding.getModifiers()))) {
                        node.getRightHandSide().accept((ASTVisitor)this);
                    }
                } else {
                    this.fNeedBindings = true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean visit(Block node) {
        if (this.visit((ASTNode)node, false)) {
            if (node.statements().isEmpty() && node.getParent().getNodeType() == 31) {
                this.fLineLocation = this.lineNumber(node.getStartPosition() + node.getLength() - 1);
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = this.computeTypeName((ASTNode)node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(BreakStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CastExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CatchClause node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(CharacterLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.visit((ASTNode)node, false)) {
            List arguments = node.arguments();
            for (ASTNode astNode : arguments) {
                if (!(astNode instanceof LambdaExpression)) continue;
                astNode.accept((ASTVisitor)this);
                return false;
            }
        }
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CompilationUnit node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ConditionalExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ContinueStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(DoStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        if (this.visit((ASTNode)node, false)) {
            node.getExpression().accept((ASTVisitor)this);
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List arguments = node.arguments();
            for (Expression exp : arguments) {
                exp.accept((ASTVisitor)this);
            }
            AnonymousClassDeclaration decl = node.getAnonymousClassDeclaration();
            if (decl != null) {
                decl.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List enumConstants = node.enumConstants();
            for (EnumConstantDeclaration econst : enumConstants) {
                econst.accept((ASTVisitor)this);
            }
            List decls = node.bodyDeclarations();
            for (BodyDeclaration body : decls) {
                body.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        if (this.fLocationFound && this.fLambdaVisited) {
            return false;
        }
        if (this.visit((ASTNode)node, false) && node.getExpression() instanceof MethodInvocation) {
            node.getExpression().accept((ASTVisitor)this);
            return false;
        }
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(FieldAccess node) {
        return this.visit((ASTNode)node, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean visit(FieldDeclaration node) {
        List fragments;
        if (!this.visit((ASTNode)node, false)) return false;
        if (this.fBestMatch && (fragments = node.fragments()).size() == 1) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            Expression init = fragment.getInitializer();
            int offset = fragment.getName().getStartPosition();
            int line = this.lineNumber(offset);
            if (Flags.isFinal((int)node.getModifiers())) {
                if (init == null) {
                    if (line != this.fLineNumber) return false;
                    this.fMemberOffset = offset;
                    this.fLineLocation = line;
                    this.fLocationType = 3;
                    this.fLocationFound = true;
                    this.fTypeName = this.computeTypeName((ASTNode)node);
                    return false;
                }
                if (line == this.fLineNumber) {
                    this.fLocationType = this.isReplacedByConstantValue(init) ? 1 : 3;
                    this.fMemberOffset = offset;
                    this.fLineLocation = line;
                    this.fLocationFound = true;
                    this.fTypeName = this.computeTypeName((ASTNode)node);
                    return false;
                }
            } else if (line == this.fLineNumber) {
                this.fMemberOffset = offset;
                this.fLineLocation = line;
                this.fLocationType = 3;
                this.fLocationFound = true;
                return false;
            }
        }
        fragments = node.fragments();
        for (VariableDeclarationFragment frag : fragments) {
            frag.accept((ASTVisitor)this);
            if (!this.fLocationFound) continue;
            return false;
        }
        return false;
    }

    public boolean visit(ForStatement node) {
        return this.visit((ASTNode)node, node.initializers().isEmpty() && node.getExpression() == null && node.updaters().isEmpty());
    }

    public boolean visit(IfStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InfixExpression node) {
        if (this.visit((ASTNode)node, false)) {
            Expression rightOperand;
            Expression leftOperand = node.getLeftOperand();
            Expression firstConstant = null;
            if (this.visit((ASTNode)leftOperand, false)) {
                leftOperand.accept((ASTVisitor)this);
                return false;
            }
            if (this.isReplacedByConstantValue(leftOperand)) {
                firstConstant = leftOperand;
            }
            if (this.visit((ASTNode)(rightOperand = node.getRightOperand()), false)) {
                if (firstConstant == null || !this.isReplacedByConstantValue(rightOperand)) {
                    rightOperand.accept((ASTVisitor)this);
                    return false;
                }
            } else {
                if (this.isReplacedByConstantValue(rightOperand)) {
                    if (firstConstant == null) {
                        firstConstant = rightOperand;
                    }
                } else {
                    firstConstant = null;
                }
                List extendedOperands = node.extendedOperands();
                for (Expression exp : extendedOperands) {
                    if (this.visit((ASTNode)exp, false)) {
                        if (firstConstant != null && this.isReplacedByConstantValue(exp)) break;
                        exp.accept((ASTVisitor)this);
                        return false;
                    }
                    if (this.isReplacedByConstantValue(exp)) {
                        if (firstConstant != null) continue;
                        firstConstant = exp;
                        continue;
                    }
                    firstConstant = null;
                }
            }
            if (firstConstant != null) {
                this.fLineLocation = this.lineNumber(firstConstant.getStartPosition());
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = this.computeTypeName((ASTNode)firstConstant);
            }
        }
        return false;
    }

    public boolean visit(Initializer node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(InstanceofExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.nestLabel(node.getLabel().getFullyQualifiedName());
        return this.visit((ASTNode)node, false);
    }

    public void endVisit(LabeledStatement node) {
        this.popLabel();
        super.endVisit(node);
    }

    private String getLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return null;
        }
        return this.fLabels.get(this.fLabels.size() - 1);
    }

    private void nestLabel(String label) {
        if (this.fLabels == null) {
            this.fLabels = new ArrayList<String>();
        }
        this.fLabels.add(label);
    }

    private void popLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return;
        }
        this.fLabels.remove(this.fLabels.size() - 1);
    }

    public boolean visit(LambdaExpression node) {
        this.fMemberOffset = node.getStartPosition();
        this.fNodeLength = node.getLength();
        if (this.fInputOffset != -1 && this.fInputLength > 0 && this.fInputOffset >= this.fMemberOffset && this.fInputOffset + this.fInputLength <= this.fMemberOffset + this.fNodeLength) {
            IMethodBinding methodBinding = node.resolveMethodBinding();
            if (methodBinding != null) {
                this.fLambdaVisited = true;
                this.fLocationType = 4;
                this.fLambdaMethodName = LambdaLocationLocatorHelper.toMethodName(methodBinding);
                this.fLambdaMethodSignature = LambdaLocationLocatorHelper.toMethodSignature(methodBinding);
                this.fLocationFound = true;
                return false;
            }
        } else if (this.fLocationType != 4) {
            this.fLocationType = 1;
            this.fTypeName = this.computeTypeName((ASTNode)node);
            int startLine = this.lineNumber(this.fMemberOffset);
            if (this.fLineNumber <= startLine) {
                this.fLineLocation = this.fInputOffset != -1 ? this.lineNumber(this.fInputOffset) : startLine;
            } else {
                ASTNode body = node.getBody();
                if (body instanceof Block) {
                    this.fLocationFound = false;
                    Block block1 = (Block)body;
                    if (this.visit(block1)) {
                        for (Object object : block1.statements()) {
                            if (!(object instanceof ASTNode)) continue;
                            ASTNode node1 = (ASTNode)object;
                            node1.accept((ASTVisitor)this);
                        }
                    }
                } else if (body instanceof Expression) {
                    body.accept((ASTVisitor)this);
                }
            }
            return false;
        }
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public boolean visit(MemberValuePair node) {
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            Block body = node.getBody();
            if (this.fBestMatch) {
                int nameOffset = node.getName().getStartPosition();
                if (this.lineNumber(nameOffset) == this.fLineNumber) {
                    if (node.getParent() instanceof AnonymousClassDeclaration) {
                        this.fLocationType = 0;
                        this.fLocationFound = true;
                        return false;
                    }
                    this.fMemberOffset = nameOffset;
                    this.fLocationType = 2;
                    this.fLocationFound = true;
                    return false;
                }
                if (body != null && this.fThroughToggle) {
                    int bodyLength;
                    int bodyStart = body.getStartPosition();
                    int bodyEnd = bodyStart + (bodyLength = body.getLength());
                    int closingBraceOffset = bodyEnd - 1;
                    if (this.lineNumber(closingBraceOffset) == this.fLineNumber) {
                        this.fMemberOffset = closingBraceOffset;
                        LOCATION_METHOD_CLOSE = true;
                        this.fLocationType = 2;
                        this.fLocationFound = true;
                        return false;
                    }
                    body.accept((ASTVisitor)this);
                }
            }
            if (body != null) {
                body.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (this.fLocationFound && this.fLambdaVisited) {
            return false;
        }
        if (this.visit((ASTNode)node, false)) {
            Expression expression = node.getExpression();
            if (expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation) {
                expression.accept((ASTVisitor)this);
            }
            if (this.fLocationFound) {
                return false;
            }
            List arguments = node.arguments();
            for (ASTNode astNode : arguments) {
                astNode.accept((ASTVisitor)this);
                if (!(astNode instanceof LambdaExpression) || !this.fLambdaVisited) continue;
                return false;
            }
        }
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(MethodRef node) {
        return false;
    }

    public boolean visit(MethodRefParameter node) {
        return false;
    }

    public boolean visit(Modifier node) {
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public boolean visit(NullLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(NumberLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParameterizedType node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(PostfixExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PrefixExpression node) {
        if (this.visit((ASTNode)node, false)) {
            if (this.isReplacedByConstantValue(node)) {
                this.fLineLocation = this.lineNumber(node.getStartPosition());
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = this.computeTypeName((ASTNode)node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(PrimitiveType node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.visit((ASTNode)node, true);
        return false;
    }

    public boolean visit(QualifiedType node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SimpleName node) {
        return this.visit((ASTNode)node, !node.getFullyQualifiedName().equals(this.getLabel()));
    }

    public boolean visit(SimpleType node) {
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(StringLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(TextBlock node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperFieldAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SwitchCase node) {
        return false;
    }

    public boolean visit(SwitchStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(SynchronizedStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public boolean visit(TextElement node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ThrowStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(TryStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(UnionType node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List bodyDeclaration = node.bodyDeclarations();
            for (BodyDeclaration body : bodyDeclaration) {
                body.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeParameter node) {
        return false;
    }

    public boolean visit(TypeLiteral node) {
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(VariableDeclarationFragment node) {
        Expression initializer = node.getInitializer();
        if (this.visit((ASTNode)node, false)) {
            int offset = node.getName().getStartPosition();
            int line = this.lineNumber(offset);
            if (initializer != null) {
                if (this.fLineNumber == line) {
                    this.fLineLocation = line;
                    this.fLocationFound = true;
                    this.fLocationType = 1;
                    this.fTypeName = this.computeTypeName((ASTNode)node);
                    if (initializer instanceof MethodInvocation || initializer instanceof LambdaExpression) {
                        initializer.accept((ASTVisitor)this);
                    }
                    return false;
                }
                initializer.accept((ASTVisitor)this);
            } else if (line == this.fLineNumber) {
                this.fMemberOffset = offset;
                this.fLineLocation = line;
                this.fLocationType = 3;
                this.fTypeName = this.computeTypeName((ASTNode)node);
                this.fLocationFound = true;
                return false;
            }
        }
        return false;
    }

    private int lineNumber(int offset) {
        int lineNumber = this.fCompilationUnit.getLineNumber(offset);
        return lineNumber < 1 ? 1 : lineNumber;
    }

    public boolean visit(WildcardType node) {
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(WhileStatement node) {
        return this.visit((ASTNode)node, false);
    }
}

