/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.variables;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.variables.Messages;
import org.eclipse.osgi.util.NLS;

public class DateTimeResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        SimpleDateFormat format = null;
        if (argument != null && argument.trim().length() > 0) {
            try {
                format = new SimpleDateFormat(argument);
            }
            catch (IllegalArgumentException e) {
                DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.DateTimeResolver_ProblemWithDateArgument, (Object)argument), (Throwable)e));
            }
        }
        if (format == null) {
            format = new SimpleDateFormat("yyyyMMdd_HHmm");
        }
        return format.format(new Date());
    }
}

