/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;

public class DevClassPathHelper {
    protected boolean inDevelopmentMode = false;
    protected String[] devDefaultClasspath;
    protected Properties devProperties = null;

    public DevClassPathHelper(Path osgiDev) {
        if (osgiDev != null) {
            this.inDevelopmentMode = true;
            this.devProperties = DevClassPathHelper.load(osgiDev);
            this.devDefaultClasspath = Utils.getArrayFromString(this.devProperties.getProperty("*"));
        }
    }

    public String[] getDevClassPath(String id) {
        String entry;
        String[] result = null;
        if (id != null && this.devProperties != null && (entry = this.devProperties.getProperty(id)) != null) {
            result = Utils.getArrayFromString(entry);
        }
        if (result == null) {
            result = this.devDefaultClasspath;
        }
        return result;
    }

    public boolean inDevelopmentMode() {
        return this.inDevelopmentMode;
    }

    private static Properties load(Path path) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_missingFile, (Object)path);
            BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 10, message, null));
        }
        return props;
    }
}

