/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.index.IIndexDocument;
import org.eclipse.rcptt.internal.core.model.index.Index;

public class IndexDocument
implements IIndexDocument {
    private String path;
    private IQ7NamedElement element;
    private Index index;

    public IndexDocument(IQ7NamedElement element, Index index) {
        this.element = element;
        this.path = element.getPath().removeFirstSegments(1).toString();
        this.index = index;
    }

    @Override
    public String getContainerRelativePath() {
        return this.path;
    }

    @Override
    public IQ7NamedElement getElement() {
        return this.element;
    }

    @Override
    public void addKey(String key, String value) {
        this.index.addKey(this.path, key, value);
    }

    @Override
    public void updateModificationStamp(long stamp) {
        this.index.updateModificationstamp(this.path, stamp);
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.index.remove(this.path);
    }
}

