/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;

public abstract class ObservableSet<E>
extends AbstractObservable
implements IObservableSet<E> {
    protected Set<E> wrappedSet;
    private boolean stale = false;
    protected Object elementType;

    protected ObservableSet(Set<E> wrappedSet, Object elementType) {
        this(Realm.getDefault(), wrappedSet, elementType);
    }

    protected ObservableSet(Realm realm, Set<E> wrappedSet, Object elementType) {
        super(realm);
        this.wrappedSet = wrappedSet;
        this.elementType = elementType;
    }

    @Override
    public synchronized void addSetChangeListener(ISetChangeListener<? super E> listener) {
        this.addListener(SetChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeSetChangeListener(ISetChangeListener<? super E> listener) {
        this.removeListener(SetChangeEvent.TYPE, listener);
    }

    protected void fireSetChange(SetDiff<E> diff) {
        super.fireChange();
        this.fireEvent(new SetChangeEvent<E>(this, diff));
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.wrappedSet.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        this.getterCalled();
        return o == this || this.wrappedSet.equals(o);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrappedSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator<E> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                ObservableTracker.getterCalled(ObservableSet.this);
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                ObservableTracker.getterCalled(ObservableSet.this);
                return wrappedIterator.next();
            }
        };
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.wrappedSet.toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.wrappedSet.toString();
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    protected void setWrappedSet(Set<E> wrappedSet) {
        this.wrappedSet = wrappedSet;
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireSetChange() instead");
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }
}

