/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.ecl.runtime.ICommandService;

public final class ScriptletDefinition {
    private final String name;
    private final String namespace;
    private final IConfigurationElement config;
    private Set<String> friendlyNames;
    private ICommandService service;

    ScriptletDefinition(String ns, String name, IConfigurationElement config) {
        this.namespace = ns;
        this.name = name;
        this.config = config;
    }

    Set<String> getFriendlyNames() {
        if (this.friendlyNames == null) {
            IConfigurationElement[] elements;
            this.friendlyNames = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = elements = this.config.getChildren("friendly_name");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String name = e.getAttribute("value");
                this.friendlyNames.add(name);
                ++n2;
            }
        }
        return this.friendlyNames;
    }

    ICommandService getService() throws CoreException {
        if (this.service == null) {
            this.service = (ICommandService)this.config.createExecutableExtension("class");
        }
        return this.service;
    }

    public EClass getEClass() {
        EPackage epackage = EPackage.Registry.INSTANCE.getEPackage(this.namespace);
        return (EClass)epackage.getEClassifier(this.name);
    }

    public String getCommandName() {
        return EclCommandNameConvention.toCommandName(this.getEClass().getName());
    }

    public boolean isInternal() {
        return this.getEClass().getEAnnotation("http://www.eclipse.org/ecl/internal") != null;
    }
}

