/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.ResultsHandler;
import org.eclipse.rcptt.runner.util.TestResult;
import org.eclipse.rcptt.runner.util.TestSuite;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportOutputStream;

public class ScenarioRunnable {
    private final IQ7NamedElement scenario;
    public final TestSuite suite;
    private final String msg;
    private final SherlockReportOutputStream reportWriter;
    private final ResultsHandler resultsHandler;

    public ScenarioRunnable(ResultsHandler resultsHandler, IQ7NamedElement scenario, TestSuite suite, String msg, SherlockReportOutputStream reportWriter) {
        Preconditions.checkNotNull((Object)resultsHandler);
        Preconditions.checkNotNull((Object)scenario);
        Preconditions.checkNotNull((Object)suite);
        Preconditions.checkNotNull((Object)msg);
        Preconditions.checkNotNull((Object)reportWriter);
        this.resultsHandler = resultsHandler;
        this.scenario = scenario;
        this.suite = suite;
        this.msg = msg;
        this.reportWriter = reportWriter;
    }

    public void run(AutThread worker) throws CoreException, InterruptedException {
        block23: {
            TestResult result = null;
            Report report = null;
            long totalTime = 0L;
            try {
                try {
                    HeadlessRunnerPlugin.getDefault().info(String.valueOf(worker) + " Starting: " + this.scenario.getName() + " " + this.msg);
                    IExecutionSession exec = Q7Launcher.getInstance().execute(new IQ7NamedElement[]{this.scenario}, (Aut)worker.launch.getAut(), "Test cases");
                    Q7TestLaunch testLaunch = exec.getLaunch();
                    try {
                        IExecutable[] executables;
                        while (exec.isRunning()) {
                            Thread.sleep(500L);
                        }
                        IExecutable[] iExecutableArray = executables = exec.getExecutables();
                        int n = executables.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IExecutable e = iExecutableArray[n2];
                            report = this.makeReport((PrepareExecutionWrapper)e);
                            if (!e.getResultStatus().isOK()) break;
                            ++n2;
                        }
                        if (executables == null || executables.length == 0) {
                            HeadlessRunnerPlugin.getDefault().info(String.valueOf(worker) + " Executing test case " + this.scenario.getName() + " is failed with unknown reason...");
                        }
                        this.suite.executablesMap.put(this.scenario, executables);
                        totalTime = exec.getTotalTime();
                        result = TestResult.collectFrom(executables, this.scenario.getElementName(), totalTime);
                    }
                    finally {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)testLaunch);
                    }
                }
                catch (Throwable e) {
                    result = this.fail(TestSuiteUtils.toString((Throwable)e), false);
                    HeadlessRunnerPlugin.logErr("Failed to execute " + this.scenario.getName(), e);
                    if (this.reportWriter != null) {
                        if (report != null) {
                            this.reportWriter.write(report);
                        } else {
                            this.addToReport(result);
                        }
                    }
                    this.resultsHandler.testCompleted(result, worker);
                    String finishMessage = String.valueOf(worker) + " Finished: " + this.scenario.getName() + " in " + totalTime;
                    if (result.reason != null && !result.reason.isEmpty()) {
                        finishMessage = finishMessage + ", " + result.reason;
                    }
                    HeadlessRunnerPlugin.getDefault().info(finishMessage + " " + this.msg);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (this.reportWriter != null) {
                    if (report != null) {
                        this.reportWriter.write(report);
                    } else {
                        this.addToReport(result);
                    }
                }
                this.resultsHandler.testCompleted(result, worker);
                String finishMessage = String.valueOf(worker) + " Finished: " + this.scenario.getName() + " in " + totalTime;
                if (result.reason != null && !result.reason.isEmpty()) {
                    finishMessage = finishMessage + ", " + result.reason;
                }
                HeadlessRunnerPlugin.getDefault().info(finishMessage + " " + this.msg);
                throw throwable;
            }
            if (this.reportWriter != null) {
                if (report != null) {
                    this.reportWriter.write(report);
                } else {
                    this.addToReport(result);
                }
            }
            this.resultsHandler.testCompleted(result, worker);
            String finishMessage = String.valueOf(worker) + " Finished: " + this.scenario.getName() + " in " + totalTime;
            if (result.reason != null && !result.reason.isEmpty()) {
                finishMessage = finishMessage + ", " + result.reason;
            }
            HeadlessRunnerPlugin.getDefault().info(finishMessage + " " + this.msg);
        }
    }

    private Report makeReport(PrepareExecutionWrapper executable) {
        Report report = executable.getResultReport();
        Preconditions.checkState((report != null ? 1 : 0) != 0, (Object)(executable.getName() + " failed to emit non-null report"));
        return report;
    }

    public TestResult skip(String message, boolean addToReport) {
        TestResult result = new TestResult(false, true, this.getScenarioName(), message, 0L, false, false, false);
        if (addToReport) {
            this.addToReport(result);
        }
        return result;
    }

    public TestResult fail(String message, boolean addToReport) {
        TestResult result = new TestResult(true, false, this.getScenarioName(), message, 0L, false, false, false);
        if (addToReport) {
            this.addToReport(result);
        }
        return result;
    }

    private void addToReport(TestResult result) {
        if (this.reportWriter == null) {
            return;
        }
        if (result.failed) {
            this.reportWriter.write(TestSuiteUtils.generateFailedReport((IQ7NamedElement)((ITestCase)this.scenario), (String)result.reason));
        } else if (result.skipped) {
            this.reportWriter.write(TestSuiteUtils.generateSkippedReport((IQ7NamedElement)((ITestCase)this.scenario), (String)result.reason));
        }
    }

    private String getScenarioName() {
        String name = this.scenario.getName();
        try {
            name = this.scenario.getElementName();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return name;
    }
}

