/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;

public class SourceReferenceUtil {
    private SourceReferenceUtil() {
    }

    public static IFile getFile(ISourceReference ref) {
        ICompilationUnit unit = SourceReferenceUtil.getCompilationUnit(ref);
        return (IFile)unit.getPrimary().getResource();
    }

    public static ICompilationUnit getCompilationUnit(ISourceReference o) {
        Assert.isTrue((!(o instanceof IClassFile) ? 1 : 0) != 0);
        if (o instanceof ICompilationUnit) {
            return (ICompilationUnit)o;
        }
        if (o instanceof IJavaElement) {
            return (ICompilationUnit)((IJavaElement)o).getAncestor(5);
        }
        return null;
    }

    private static boolean hasParentInSet(IJavaElement elem, Set<ISourceReference> set) {
        IJavaElement parent = elem.getParent();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static ISourceReference[] removeAllWithParentsSelected(ISourceReference[] elems) {
        HashSet<ISourceReference> set = new HashSet<ISourceReference>(Arrays.asList(elems));
        ArrayList<ISourceReference> result = new ArrayList<ISourceReference>(elems.length);
        ISourceReference[] iSourceReferenceArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceReference elem = iSourceReferenceArray[n2];
            if (!(elem instanceof IJavaElement) || !SourceReferenceUtil.hasParentInSet((IJavaElement)elem, set)) {
                result.add(elem);
            }
            ++n2;
        }
        return result.toArray(new ISourceReference[result.size()]);
    }

    public static ISourceReference[] sortByOffset(ISourceReference[] methods) {
        Arrays.sort(methods, (o1, o2) -> {
            try {
                return o2.getSourceRange().getOffset() - o1.getSourceRange().getOffset();
            }
            catch (JavaModelException e) {
                return o2.hashCode() - o1.hashCode();
            }
        });
        return methods;
    }
}

