/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertForLoopOperation;
import org.eclipse.jdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ConvertLoopFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private final IStatus fStatus;

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean convertForLoops, boolean convertIterableForLoops, boolean makeFinal, boolean checkIfLoopVarUsed) {
        if (!convertForLoops && !convertIterableForLoops) {
            return null;
        }
        ArrayList<ConvertLoopOperation> operations = new ArrayList<ConvertLoopOperation>();
        ControlStatementFinder finder = new ControlStatementFinder(convertForLoops, convertIterableForLoops, makeFinal, checkIfLoopVarUsed, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]);
        return new ConvertLoopFixCore(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops, null);
    }

    public static ConvertLoopFixCore createConvertForLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(loop);
        if (!((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
            return null;
        }
        return new ConvertLoopFixCore(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{convertForLoopOperation}, null);
    }

    public static ConvertLoopFixCore createConvertIterableLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertIterableLoopOperation loopConverter = new ConvertIterableLoopOperation(loop);
        IStatus status = loopConverter.satisfiesPreconditions();
        if (status.getSeverity() == 4) {
            return null;
        }
        return new ConvertLoopFixCore(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{loopConverter}, status);
    }

    protected ConvertLoopFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations, IStatus status) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fStatus = status;
    }

    @Override
    public IStatus getStatus() {
        return this.fStatus;
    }

    public static final class ControlStatementFinder
    extends GenericVisitor {
        private final List<ConvertLoopOperation> fResult;
        private final Hashtable<ForStatement, String> fUsedNames;
        private final boolean fFindForLoopsToConvert;
        private final boolean fConvertIterableForLoops;
        private final boolean fMakeFinal;
        private final boolean fCheckIfLoopVarUsed;
        private ConvertLoopOperation fParentOperation;

        public ControlStatementFinder(boolean findForLoopsToConvert, boolean convertIterableForLoops, boolean makeFinal, boolean checkIfLoopVarUsed, List<ConvertLoopOperation> resultingCollection) {
            this.fFindForLoopsToConvert = findForLoopsToConvert;
            this.fConvertIterableForLoops = convertIterableForLoops;
            this.fMakeFinal = makeFinal;
            this.fCheckIfLoopVarUsed = checkIfLoopVarUsed;
            this.fResult = resultingCollection;
            this.fUsedNames = new Hashtable();
            this.fParentOperation = null;
        }

        @Override
        public boolean visit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                ForStatement current = node;
                ConvertLoopOperation operation = this.getConvertOperation(current);
                if (this.fParentOperation != null) {
                    this.fParentOperation.setChildLoopOperation(operation);
                }
                this.fParentOperation = operation;
                ConvertLoopOperation oldOperation = null;
                while (operation != null) {
                    if (oldOperation == null) {
                        this.fResult.add(operation);
                    } else {
                        oldOperation.setBodyConverter(operation);
                    }
                    if (current.getBody() instanceof ForStatement) {
                        current = (ForStatement)current.getBody();
                        oldOperation = operation;
                        operation = this.getConvertOperation(current);
                        oldOperation.setChildLoopOperation(operation);
                        this.fParentOperation = operation;
                        continue;
                    }
                    operation = null;
                }
                current.getBody().accept((ASTVisitor)this);
                return false;
            }
            return super.visit(node);
        }

        private ConvertLoopOperation getConvertOperation(ForStatement node) {
            ConvertIterableLoopOperation iterableConverter;
            Collection<String> usedNamesCollection = this.fUsedNames.values();
            String[] usedNames = usedNamesCollection.toArray(new String[usedNamesCollection.size()]);
            ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(node, usedNames, this.fMakeFinal, this.fCheckIfLoopVarUsed);
            if (((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
                if (this.fFindForLoopsToConvert) {
                    this.fUsedNames.put(node, ((ConvertLoopOperation)convertForLoopOperation).getIntroducedVariableName());
                    return convertForLoopOperation;
                }
            } else if (this.fConvertIterableForLoops && ((ConvertLoopOperation)(iterableConverter = new ConvertIterableLoopOperation(node, usedNames, this.fMakeFinal, this.fCheckIfLoopVarUsed))).satisfiesPreconditions().isOK()) {
                this.fUsedNames.put(node, ((ConvertLoopOperation)iterableConverter).getIntroducedVariableName());
                return iterableConverter;
            }
            return null;
        }

        @Override
        public void endVisit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                this.fUsedNames.remove(node);
            }
            super.endVisit(node);
        }
    }
}

