/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.ctxhelp.text;

import org.eclipse.pde.internal.core.text.DocumentNodeFactory;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpCommand;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpContext;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpDescription;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpRoot;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpTopic;

public class CtxHelpDocumentFactory
extends DocumentNodeFactory {
    private final CtxHelpModel fModel;

    public CtxHelpDocumentFactory(CtxHelpModel model) {
        this.fModel = model;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        if (this.isRoot(name)) {
            return this.createRoot();
        }
        if (this.isContext(name)) {
            return this.createContext();
        }
        if (this.isDescription(name)) {
            return this.createDescription();
        }
        if (this.isTopic(name)) {
            return this.createTopic();
        }
        if (this.isCommand(name)) {
            return this.createCommand();
        }
        return super.createDocumentNode(name, parent);
    }

    private boolean isRoot(String name) {
        return name.equals("contexts");
    }

    private boolean isContext(String name) {
        return name.equals("context");
    }

    private boolean isDescription(String name) {
        return name.equals("description");
    }

    private boolean isTopic(String name) {
        return name.equals("topic");
    }

    private boolean isCommand(String name) {
        return name.equals("command");
    }

    public CtxHelpRoot createRoot() {
        return new CtxHelpRoot(this.fModel);
    }

    public CtxHelpContext createContext() {
        return new CtxHelpContext(this.fModel);
    }

    public CtxHelpDescription createDescription() {
        return new CtxHelpDescription(this.fModel);
    }

    public CtxHelpTopic createTopic() {
        return new CtxHelpTopic(this.fModel);
    }

    public CtxHelpCommand createCommand() {
        return new CtxHelpCommand(this.fModel);
    }
}

