/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaObject;

public class ChoiceRestriction
extends SchemaObject
implements ISchemaRestriction {
    private static final long serialVersionUID = 1L;
    private ISchemaSimpleType baseType;
    private List<ISchemaEnumeration> children;
    public static final String P_CHOICES = "choices";

    public ChoiceRestriction(ISchema schema) {
        super(schema, "__choice__");
    }

    public ChoiceRestriction(ChoiceRestriction source) {
        this(source.getSchema());
        ISchemaEnumeration[] choices;
        this.children = new Vector<ISchemaEnumeration>();
        ISchemaEnumeration[] iSchemaEnumerationArray = choices = source.getChildren();
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            ISchemaEnumeration choice = iSchemaEnumerationArray[n2];
            this.children.add(new SchemaEnumeration(this, choice.getName()));
            ++n2;
        }
    }

    @Override
    public ISchemaSimpleType getBaseType() {
        return this.baseType;
    }

    public ISchemaEnumeration[] getChildren() {
        return this.children != null ? this.children.toArray(new ISchemaEnumeration[this.children.size()]) : new ISchemaEnumeration[]{};
    }

    public String[] getChoicesAsStrings() {
        if (this.children == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.children.size()) {
            ISchemaEnumeration enumeration = this.children.get(i);
            result.add(enumeration.getName());
            ++i;
        }
        String[] choices = new String[result.size()];
        result.toArray(choices);
        return choices;
    }

    @Override
    public ISchemaObject getParent() {
        if (this.baseType != null) {
            return this.baseType.getSchema();
        }
        return super.getParent();
    }

    @Override
    public boolean isValueValid(Object value) {
        if (this.children == null) {
            return false;
        }
        String svalue = value.toString();
        int i = 0;
        while (i < this.children.size()) {
            ISchemaEnumeration enumeration = this.children.get(i);
            if (enumeration.getName().equals(svalue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setBaseType(ISchemaSimpleType baseType) {
        this.baseType = baseType;
    }

    public void setChildren(List<ISchemaEnumeration> children) {
        List<ISchemaEnumeration> oldValue = this.children;
        this.children = children;
        if (this.getParent() != null) {
            this.getSchema().fireModelObjectChanged(this, P_CHOICES, oldValue, children);
        }
    }

    @Override
    public String toString() {
        if (this.children == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.children.size()) {
            ISchemaEnumeration child = this.children.get(i);
            if (child instanceof ISchemaEnumeration) {
                ISchemaEnumeration enumeration = child;
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(enumeration.getName());
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.println(indent + "<restriction base=\"" + this.baseType.getName() + "\">");
        int i = 0;
        while (i < this.children.size()) {
            ISchemaEnumeration child = this.children.get(i);
            if (child instanceof ISchemaEnumeration) {
                ISchemaEnumeration enumeration = child;
                enumeration.write(indent + "   ", writer);
            }
            ++i;
        }
        writer.println(indent + "</restriction>");
    }
}

