/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MissingRefMetadata
implements IMetadata {
    public static final String PROFILE = "profile";
    public static final String RUNATDATE = "runatdate";
    public static final String REPORTLOCATION = "reportlocation";
    public static final String APIUUSESCANS = "apiusescans";
    public static final String VALUE = "value";
    public static final String METADATA = "metadata";
    private String profile = null;
    private String runatdate = null;
    private String reportlocation = null;
    private String apiusescans = null;

    public MissingRefMetadata() {
    }

    public MissingRefMetadata(String profile, String reportlocation, String apiusescans) {
        this.profile = profile;
        this.runatdate = DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        this.reportlocation = reportlocation;
        this.apiusescans = apiusescans;
    }

    public static MissingRefMetadata getMetadata(File xmlFile) throws Exception {
        MissingRefMetadata metadata = new MissingRefMetadata();
        if (xmlFile.exists()) {
            try {
                String xmlstr = Util.getFileContentAsString(xmlFile);
                Element doc = Util.parseDocument(xmlstr.trim());
                NodeList nodes = doc.getElementsByTagName("*");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    String value = element.getAttribute(VALUE);
                    String name = element.getNodeName();
                    if (PROFILE.equals(name)) {
                        metadata.setProfile(value);
                    } else if (RUNATDATE.equals(name)) {
                        metadata.setRunAtDate(value);
                    } else if (REPORTLOCATION.equals(name)) {
                        metadata.setReportLocation(value);
                    } else if (APIUUSESCANS.equals(name)) {
                        metadata.setApiUseScans(value);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw new Exception(NLS.bind((String)SearchMessages.MissingRefMetadata_CoreExceptionInParsing, (Object)xmlFile.getAbsolutePath()));
            }
        }
        return metadata;
    }

    @Override
    public void serializeToFile(Path file) throws IOException, CoreException {
        Document doc = Util.newDocument();
        Element root = doc.createElement(METADATA);
        doc.appendChild(root);
        Element child = doc.createElement(PROFILE);
        root.appendChild(child);
        child.setAttribute(VALUE, this.profile);
        child = doc.createElement(RUNATDATE);
        root.appendChild(child);
        child.setAttribute(VALUE, this.runatdate);
        child = doc.createElement(REPORTLOCATION);
        root.appendChild(child);
        child.setAttribute(VALUE, this.reportlocation);
        child = doc.createElement(APIUUSESCANS);
        root.appendChild(child);
        child.setAttribute(VALUE, this.apiusescans);
        Util.writeDocumentToFile(doc, file);
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setRunAtDate(String date) {
        this.runatdate = date;
    }

    public String getRunAtDate() {
        return this.runatdate;
    }

    public String getReportLocation() {
        return this.reportlocation;
    }

    public void setReportLocation(String location) {
        this.reportlocation = location;
    }

    public String getApiUseScans() {
        return this.apiusescans;
    }

    public void setApiUseScans(String apiusescans) {
        this.apiusescans = apiusescans;
    }
}

