/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.properties;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeType;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceSupport {
    public static boolean map(IWorkbenchPart part, IPropertySource source, DiagramItem diagramItem) {
        IPropertyDescriptor[] iPropertyDescriptorArray = source.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor d = iPropertyDescriptorArray[n2];
            PropertyNode entry = UiFactory.eINSTANCE.createPropertyNode();
            entry.setName(d.getDisplayName());
            entry.setType(PropertyNodeType.PROPERTY);
            entry.setValue(PropertySourceSupport.getStringValue(source, d));
            diagramItem.getModelPropertyNodes().add((Object)entry);
            ++n2;
        }
        return true;
    }

    public static boolean isSourcePropertiesMapped(IWorkbenchPart part, IPropertySource source) {
        return true;
    }

    public static PropertyNodeList getPropertyNodes(IWorkbenchPart part, IPropertySource source, String nodePath) {
        return null;
    }

    public static String getPropertyValue(IWorkbenchPart part, IPropertySource source, String nodePath) {
        IPropertyDescriptor[] iPropertyDescriptorArray = source.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor d = iPropertyDescriptorArray[n2];
            if (d.getDisplayName().equals(nodePath)) {
                return PropertySourceSupport.getStringValue(source, d);
            }
            ++n2;
        }
        return null;
    }

    private static String getStringValue(IPropertySource source, IPropertyDescriptor descriptor) {
        Object value = source.getPropertyValue(descriptor.getId());
        if (value == null) {
            return "";
        }
        ILabelProvider labelProvider = descriptor.getLabelProvider();
        if (labelProvider == null) {
            return value.toString();
        }
        String text = labelProvider.getText(value);
        if (text == null) {
            return "";
        }
        return text;
    }
}

