/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.internal.compiler.parser.TerminalToken;

public final class HashtableOfObjectToTokenArray
implements Cloneable {
    public Object[] keyTable;
    public TerminalToken[][] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfObjectToTokenArray() {
        this(13);
    }

    public HashtableOfObjectToTokenArray(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new Object[extraRoom];
        this.valueTable = new TerminalToken[extraRoom][];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObjectToTokenArray result = (HashtableOfObjectToTokenArray)super.clone();
        result.elementSize = this.elementSize;
        result.threshold = this.threshold;
        int length = this.keyTable.length;
        result.keyTable = new Object[length];
        System.arraycopy(this.keyTable, 0, result.keyTable, 0, length);
        length = this.valueTable.length;
        result.valueTable = new TerminalToken[length][];
        System.arraycopy(this.valueTable, 0, result.valueTable, 0, length);
        return result;
    }

    public boolean containsKey(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                return true;
            }
            if (++index != length) continue;
            index = 0;
        }
        return false;
    }

    public TerminalToken[] get(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    public void keysToArray(Object[] array) {
        int index = 0;
        Object[] objectArray = this.keyTable;
        int n = this.keyTable.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (key != null) {
                array[index++] = key;
            }
            ++n2;
        }
    }

    public TerminalToken[] put(Object key, TerminalToken[] value) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                this.valueTable[index] = value;
                return value;
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    public TerminalToken[] removeKey(Object key) {
        Object currentKey;
        int length = this.keyTable.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                TerminalToken[] value = this.valueTable[index];
                --this.elementSize;
                this.keyTable[index] = null;
                this.rehash();
                return value;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void rehash() {
        HashtableOfObjectToTokenArray newHashtable = new HashtableOfObjectToTokenArray(this.elementSize * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            Object currentKey = this.keyTable[i];
            if (currentKey == null) continue;
            newHashtable.put(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int length = this.keyTable.length;
        while (i < length) {
            Object key = this.keyTable[i];
            if (key != null) {
                buffer.append(key).append(" -> ");
                TerminalToken[] ints = this.valueTable[i];
                buffer.append('[');
                if (ints != null) {
                    int j = 0;
                    int max = ints.length;
                    while (j < max) {
                        if (j > 0) {
                            buffer.append(',');
                        }
                        buffer.append((Object)ints[j]);
                        ++j;
                    }
                }
                buffer.append("]\n");
            }
            ++i;
        }
        return String.valueOf(buffer);
    }
}

