/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SplitPackageBinding
extends PackageBinding {
    Set<ModuleBinding> declaringModules = new LinkedHashSet<ModuleBinding>();
    public Set<PlainPackageBinding> incarnations = new LinkedHashSet<PlainPackageBinding>();
    public static Consumer<SplitPackageBinding> instanceListener;
    private static int RANK_VALID;

    static {
        RANK_VALID = 3;
    }

    public static PackageBinding combine(PackageBinding binding, PackageBinding previous, ModuleBinding primaryModule) {
        int curRank;
        int prevRank = SplitPackageBinding.rank(previous);
        if (prevRank < (curRank = SplitPackageBinding.rank(binding))) {
            return binding;
        }
        if (prevRank > curRank) {
            return previous;
        }
        if (previous == null) {
            return null;
        }
        if (previous.subsumes(binding)) {
            return previous;
        }
        if (binding.subsumes(previous)) {
            return binding;
        }
        SplitPackageBinding split = new SplitPackageBinding(previous, primaryModule);
        split.add(binding);
        return split;
    }

    public static PackageBinding combineAll(List<PackageBinding> bindings, ModuleBinding primaryModule) {
        int[] numRanked = new int[RANK_VALID + 1];
        for (PackageBinding packageBinding : bindings) {
            int rank;
            int n = rank = SplitPackageBinding.rank(packageBinding);
            numRanked[n] = numRanked[n] + 1;
        }
        SplitPackageBinding split = null;
        int rank = RANK_VALID;
        while (rank >= 0) {
            int num = numRanked[rank];
            if (num > 0) {
                for (PackageBinding packageBinding : bindings) {
                    if (SplitPackageBinding.rank(packageBinding) != rank) continue;
                    if (num == 1 || rank != RANK_VALID) {
                        return packageBinding;
                    }
                    if (split == null) {
                        split = new SplitPackageBinding(packageBinding, primaryModule);
                        continue;
                    }
                    split.add(packageBinding);
                }
                if (split.incarnations.size() == 1) {
                    return split.incarnations.iterator().next();
                }
                return split;
            }
            --rank;
        }
        return null;
    }

    private static int rank(PackageBinding candidate) {
        if (candidate == null) {
            return 0;
        }
        if (candidate == LookupEnvironment.TheNotFoundPackage) {
            return 1;
        }
        if (!candidate.isValidBinding()) {
            return 2;
        }
        return RANK_VALID;
    }

    public SplitPackageBinding(PackageBinding initialBinding, ModuleBinding primaryModule) {
        super(initialBinding.compoundName, initialBinding.parent, primaryModule.environment, primaryModule);
        this.add(initialBinding);
        if (instanceListener != null) {
            instanceListener.accept(this);
        }
    }

    public void add(PackageBinding packageBinding) {
        if (packageBinding instanceof SplitPackageBinding) {
            SplitPackageBinding split = (SplitPackageBinding)packageBinding;
            this.declaringModules.addAll(split.declaringModules);
            for (PlainPackageBinding incarnation : split.incarnations) {
                if (!this.incarnations.add(incarnation)) continue;
                incarnation.addWrappingSplitPackageBinding(this);
            }
        } else if (packageBinding instanceof PlainPackageBinding) {
            this.declaringModules.add(packageBinding.enclosingModule);
            if (this.incarnations.add((PlainPackageBinding)packageBinding)) {
                packageBinding.addWrappingSplitPackageBinding(this);
            }
        }
    }

    @Override
    PackageBinding addPackage(PackageBinding element, ModuleBinding module) {
        PlainPackageBinding elementIncarnation;
        char[] simpleName = element.compoundName[element.compoundName.length - 1];
        element = this.combineWithSiblings(element, simpleName, module);
        PackageBinding visible = (PackageBinding)this.knownPackages.get(simpleName);
        visible = SplitPackageBinding.combine(element, visible, this.enclosingModule);
        this.knownPackages.put(simpleName, visible);
        PlainPackageBinding incarnation = this.getIncarnation(element.enclosingModule);
        if (incarnation != null && (elementIncarnation = element.getIncarnation(element.enclosingModule)) != null) {
            incarnation.addPackage(elementIncarnation, module);
        }
        return element;
    }

    PackageBinding combineWithSiblings(PackageBinding childPackage, char[] name, ModuleBinding module) {
        ModuleBinding primaryModule = childPackage.enclosingModule;
        char[] flatName = CharOperation.concatWith(childPackage.compoundName, '.');
        ArrayList<PackageBinding> bindings = new ArrayList<PackageBinding>();
        for (PackageBinding packageBinding : this.incarnations) {
            PlainPackageBinding next;
            ModuleBinding moduleBinding = packageBinding.enclosingModule;
            if (moduleBinding == module || childPackage.isDeclaredIn(moduleBinding) || (next = moduleBinding.getDeclaredPackage(flatName)) == null) continue;
            bindings.add(next);
        }
        if (bindings.isEmpty()) {
            return childPackage;
        }
        bindings.add(childPackage);
        return SplitPackageBinding.combineAll(bindings, primaryModule);
    }

    @Override
    ModuleBinding[] getDeclaringModules() {
        return this.declaringModules.toArray(new ModuleBinding[this.declaringModules.size()]);
    }

    @Override
    PackageBinding getPackage0(char[] name) {
        PackageBinding knownPackage = super.getPackage0(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        ArrayList<PackageBinding> bindings = new ArrayList<PackageBinding>();
        for (PackageBinding packageBinding : this.incarnations) {
            PackageBinding package0 = packageBinding.getPackage0(name);
            if (package0 == null) {
                return null;
            }
            bindings.add(package0);
        }
        PackageBinding packageBinding = SplitPackageBinding.combineAll(bindings, this.enclosingModule);
        if (packageBinding != null) {
            this.knownPackages.put(name, packageBinding);
        }
        return packageBinding;
    }

    @Override
    PackageBinding getPackage0Any(char[] name) {
        PackageBinding knownPackage = super.getPackage0(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        ArrayList<PackageBinding> bindings = new ArrayList<PackageBinding>();
        for (PackageBinding packageBinding : this.incarnations) {
            PackageBinding package0 = packageBinding.getPackage0(name);
            if (package0 == null) continue;
            bindings.add(package0);
        }
        return SplitPackageBinding.combineAll(bindings, this.enclosingModule);
    }

    @Override
    protected PackageBinding findPackage(char[] name, ModuleBinding module) {
        char[][] subpackageCompoundName = CharOperation.arrayConcat(this.compoundName, name);
        LinkedHashSet<PackageBinding> candidates = new LinkedHashSet<PackageBinding>();
        for (ModuleBinding candidateModule : this.declaringModules) {
            PackageBinding candidate = candidateModule.getVisiblePackage(subpackageCompoundName);
            if (candidate == null || candidate == LookupEnvironment.TheNotFoundPackage || (candidate.tagBits & 0x80L) != 0L) continue;
            candidates.add(candidate);
        }
        int count = candidates.size();
        PackageBinding result = null;
        if (count == 1) {
            result = (PackageBinding)candidates.iterator().next();
        } else if (count > 1) {
            Iterator iterator = candidates.iterator();
            SplitPackageBinding split = new SplitPackageBinding((PackageBinding)iterator.next(), this.enclosingModule);
            while (iterator.hasNext()) {
                split.add((PackageBinding)iterator.next());
            }
            result = split;
        }
        if (result == null) {
            this.addNotFoundPackage(name);
        } else {
            this.addPackage(result, module);
        }
        return result;
    }

    @Override
    public PlainPackageBinding getIncarnation(ModuleBinding requestedModule) {
        for (PlainPackageBinding incarnation : this.incarnations) {
            if (incarnation.enclosingModule != requestedModule) continue;
            return incarnation;
        }
        return null;
    }

    @Override
    public boolean subsumes(PackageBinding binding) {
        if (!CharOperation.equals(this.compoundName, binding.compoundName)) {
            return false;
        }
        if (binding instanceof SplitPackageBinding) {
            return this.declaringModules.containsAll(((SplitPackageBinding)binding).declaringModules);
        }
        return this.declaringModules.contains(binding.enclosingModule);
    }

    @Override
    boolean hasType0Any(char[] name) {
        if (super.hasType0Any(name)) {
            return true;
        }
        for (PackageBinding packageBinding : this.incarnations) {
            if (!packageBinding.hasType0Any(name)) continue;
            return true;
        }
        return false;
    }

    ReferenceBinding getType0ForModule(ModuleBinding module, char[] name) {
        if (this.declaringModules.contains(module)) {
            return this.getIncarnation(module).getType0(name);
        }
        return null;
    }

    @Override
    ReferenceBinding getType(char[] name, ModuleBinding mod) {
        ReferenceBinding candidate = null;
        boolean accessible = false;
        for (PackageBinding packageBinding : this.incarnations) {
            ReferenceBinding type = packageBinding.getType(name, mod);
            if (type == null) continue;
            if (candidate == null || !accessible) {
                candidate = type;
                accessible = mod.canAccess(packageBinding);
                continue;
            }
            if (!mod.canAccess(packageBinding)) continue;
            return new ProblemReferenceBinding(type.compoundName, candidate, 3);
        }
        if (candidate != null && !accessible) {
            return new ProblemReferenceBinding(candidate.compoundName, candidate, 30);
        }
        return candidate;
    }

    @Override
    public boolean isDeclaredIn(ModuleBinding moduleBinding) {
        return this.declaringModules.contains(moduleBinding);
    }

    @Override
    public PackageBinding getVisibleFor(ModuleBinding clientModule, boolean preferLocal) {
        int visibleCountInNamedModules = 0;
        PlainPackageBinding uniqueInNamedModules = null;
        PlainPackageBinding bindingInUnnamedModule = null;
        for (PlainPackageBinding incarnation : this.incarnations) {
            if (!incarnation.hasCompilationUnit(false)) continue;
            if (preferLocal && incarnation.enclosingModule == clientModule) {
                return incarnation;
            }
            if (!clientModule.canAccess(incarnation)) continue;
            if (incarnation.enclosingModule.isUnnamed()) {
                bindingInUnnamedModule = incarnation;
                continue;
            }
            ++visibleCountInNamedModules;
            uniqueInNamedModules = incarnation;
        }
        if (visibleCountInNamedModules > 1) {
            return this;
        }
        if (visibleCountInNamedModules == 1) {
            if (this.environment.globalOptions.ignoreUnnamedModuleForSplitPackage || bindingInUnnamedModule == null) {
                return uniqueInNamedModules;
            }
            return this;
        }
        return bindingInUnnamedModule;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(" (from ");
        String sep = "";
        for (ModuleBinding mod : this.declaringModules) {
            buf.append(sep).append(mod.readableName());
            sep = ", ";
        }
        buf.append(")");
        return buf.toString();
    }
}

