/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug.model;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.launching.debug.model.DebugModelMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class AntLineBreakpoint
extends LineBreakpoint {
    public AntLineBreakpoint() {
    }

    public AntLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap<String, Object>(), true);
    }

    public AntLineBreakpoint(IResource resource, int lineNumber, Map<String, Object> attributes, boolean register) throws CoreException {
        IWorkspaceRunnable wr = monitor -> {
            IMarker marker = resource.createMarker("org.eclipse.ant.ui.antLineBreakpointMarker");
            this.setMarker(marker);
            attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
            attributes.put("lineNumber", lineNumber);
            attributes.put("org.eclipse.debug.core.id", "org.eclipse.ant.ui.debug");
            attributes.put("message", MessageFormat.format(DebugModelMessages.AntLineBreakpoint_0, Integer.toString(lineNumber)));
            this.ensureMarker().setAttributes(attributes);
            this.register(register);
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public String getModelIdentifier() {
        return "org.eclipse.ant.ui.debug";
    }

    public boolean isRunToLine() {
        try {
            return this.ensureMarker().getAttribute("org.eclipse.ant.ui.runToLineBreakpoint", false);
        }
        catch (DebugException e) {
            return false;
        }
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }
}

