/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.builder;

public class Q7Problem {
    private String message;
    private int line;
    private int offset;
    private int severity;
    private int length;
    private int id;

    public Q7Problem(String message, int line, int offset, int severity) {
        this.message = message;
        this.line = line;
        this.offset = offset;
        this.severity = severity;
        this.length = -1;
        this.id = -1;
    }

    public Q7Problem(String message, int line, int offset, int severity, int length, int id) {
        this(message, line, offset, severity);
        this.length = length;
        this.id = id;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getSourceId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.line;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + this.severity;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Q7Problem other = (Q7Problem)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return this.id == other.id;
    }
}

