/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class StaticImportFavoritesCompletionInvoker {
    private ICompilationUnit fCu;
    private ICompilationUnit fNewCU;
    private String[] fFavourites;

    public StaticImportFavoritesCompletionInvoker(ICompilationUnit cu, String[] favourites) {
        this.fCu = cu;
        this.fFavourites = favourites;
    }

    public void destroy() throws JavaModelException {
        if (this.fNewCU != null) {
            this.fNewCU.discardWorkingCopy();
        }
    }

    public String[] getStaticImportFavorites(final String elementName, boolean isMethod) throws JavaModelException {
        String[] res;
        if (this.fNewCU == null) {
            this.fNewCU = this.fCu.getWorkingCopy(null);
        }
        if ((res = this.createNewCompilationUnit(elementName)).length != 2) {
            return new String[0];
        }
        String dummyCuContent = res[0];
        int offset = Integer.parseInt(res[1]);
        this.fNewCU.getBuffer().setContents(dummyCuContent);
        final HashSet result = new HashSet();
        CompletionRequestor requestor = new CompletionRequestor(true){

            public void accept(CompletionProposal proposal) {
                if (elementName.equals(new String(proposal.getName()))) {
                    CompletionProposal[] completionProposalArray = proposal.getRequiredProposals();
                    int n = completionProposalArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompletionProposal curr = completionProposalArray[n2];
                        if (curr.getKind() == 22 || curr.getKind() == 21) {
                            result.add(JavaModelUtil.concatenateName(Signature.toCharArray((char[])curr.getDeclarationSignature()), curr.getName()));
                        }
                        ++n2;
                    }
                }
            }
        };
        if (isMethod) {
            requestor.setIgnored(6, false);
            requestor.setAllowsRequiredProposals(6, 22, true);
        } else {
            requestor.setIgnored(2, false);
            requestor.setAllowsRequiredProposals(2, 21, true);
        }
        requestor.setFavoriteReferences(this.fFavourites);
        this.fNewCU.codeComplete(offset, requestor, (IProgressMonitor)new NullProgressMonitor());
        return result.toArray(new String[result.size()]);
    }

    private String[] createNewCompilationUnit(String elementName) {
        StringBuilder dummyCU = new StringBuilder();
        String packName = this.fCu.getParent().getElementName();
        IType type = this.fCu.findPrimaryType();
        if (type == null) {
            return new String[0];
        }
        if (packName.length() > 0) {
            dummyCU.append("package ").append(packName).append(';');
        }
        dummyCU.append("public class ").append(type.getElementName()).append("{\n static {\n").append(elementName);
        String offset = Integer.toString(dummyCU.length());
        dummyCU.append("\n}\n }");
        return new String[]{dummyCU.toString(), offset};
    }
}

