/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSPropertyFileModifier {
    public static Change create(NLSSubstitution[] nlsSubstitutions, IPath propertyFilePath) throws CoreException {
        String name = Messages.format(NLSMessages.NLSPropertyFileModifier_change_name, BasicElementLabels.getPathLabel(propertyFilePath, false));
        TextFileChange textChange = null;
        if (!Checks.resourceExists(propertyFilePath)) {
            IProject project = NLSPropertyFileModifier.getFileHandle(propertyFilePath).getProject();
            String lineDelimiter = StubUtility.getLineDelimiterPreference(project);
            Document document = new Document();
            document.setInitialLineDelimiter(lineDelimiter);
            textChange = new DocumentChange(name, (IDocument)document);
            NLSPropertyFileModifier.addChanges((TextChange)textChange, nlsSubstitutions);
            textChange.perform((IProgressMonitor)new NullProgressMonitor());
            String encoding = null;
            IContentType javaPropertiesContentType = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaProperties");
            IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(propertyFilePath.lastSegment());
            if (contentTypes.length == 0 || contentTypes.length > 1 || !contentTypes[0].equals(javaPropertiesContentType)) {
                if (javaPropertiesContentType != null) {
                    encoding = javaPropertiesContentType.getDefaultCharset();
                }
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
            }
            return new CreateTextFileChange(propertyFilePath, textChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), encoding, "properties");
        }
        textChange = new TextFileChange(name, NLSPropertyFileModifier.getPropertyFile(propertyFilePath));
        textChange.setTextType("properties");
        NLSPropertyFileModifier.addChanges((TextChange)textChange, nlsSubstitutions);
        return textChange;
    }

    public static Change removeKeys(IPath propertyFilePath, List<String> keys) throws CoreException {
        String name = Messages.format(NLSMessages.NLSPropertyFileModifier_remove_from_property_file, BasicElementLabels.getPathLabel(propertyFilePath, false));
        TextFileChange textChange = new TextFileChange(name, NLSPropertyFileModifier.getPropertyFile(propertyFilePath));
        textChange.setTextType("properties");
        PropertyFileDocumentModel model = new PropertyFileDocumentModel(textChange.getCurrentDocument((IProgressMonitor)new NullProgressMonitor()));
        for (String key : keys) {
            DeleteEdit edit = model.remove(key);
            if (edit == null) continue;
            TextChangeCompatibility.addTextEdit((TextChange)textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_remove_entry, BasicElementLabels.getJavaElementName(key)), (TextEdit)edit);
        }
        return textChange;
    }

    private static IFile getPropertyFile(IPath propertyFilePath) {
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(propertyFilePath);
    }

    private static IFile getFileHandle(IPath propertyFilePath) {
        if (propertyFilePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(propertyFilePath);
    }

    private static void addChanges(TextChange textChange, NLSSubstitution[] substitutions) throws CoreException {
        PropertyFileDocumentModel model = new PropertyFileDocumentModel(textChange.getCurrentDocument((IProgressMonitor)new NullProgressMonitor()));
        HashMap<String, NLSSubstitution> newKeyToSubstMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(substitutions);
        HashMap<String, NLSSubstitution> oldKeyToSubstMap = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(substitutions);
        NLSPropertyFileModifier.addInsertEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
        NLSPropertyFileModifier.addRemoveEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
        NLSPropertyFileModifier.addReplaceEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
    }

    static HashMap<String, NLSSubstitution> getNewKeyToSubstitutionMap(NLSSubstitution[] substitutions) {
        HashMap<String, NLSSubstitution> keyToSubstMap = new HashMap<String, NLSSubstitution>(substitutions.length);
        NLSSubstitution[] nLSSubstitutionArray = substitutions;
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution val;
            NLSSubstitution curr = nLSSubstitutionArray[n2];
            if (curr.getState() == 0 && ((val = keyToSubstMap.get(curr.getKey())) == null || val.hasPropertyFileChange() && !curr.hasPropertyFileChange())) {
                keyToSubstMap.put(curr.getKey(), curr);
            }
            ++n2;
        }
        return keyToSubstMap;
    }

    static HashMap<String, NLSSubstitution> getOldKeyToSubstitutionMap(NLSSubstitution[] substitutions) {
        HashMap<String, NLSSubstitution> keyToSubstMap = new HashMap<String, NLSSubstitution>(substitutions.length);
        NLSSubstitution[] nLSSubstitutionArray = substitutions;
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution fav;
            String key;
            NLSSubstitution curr = nLSSubstitutionArray[n2];
            if (curr.getInitialState() == 0 && (key = curr.getInitialKey()) != null && ((fav = keyToSubstMap.get(key)) == null || fav.hasStateChanged() && !curr.hasStateChanged())) {
                keyToSubstMap.put(key, curr);
            }
            ++n2;
        }
        return keyToSubstMap;
    }

    static boolean doReplace(NLSSubstitution substitution, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap) {
        if (substitution.getState() != 0 || substitution.hasStateChanged() || substitution.getInitialValue() == null) {
            return false;
        }
        if (oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution) {
            return false;
        }
        return (substitution.isKeyRename() || substitution.isValueRename()) && newKeyToSubstMap.get(substitution.getKey()) == substitution;
    }

    private static void addReplaceEdits(TextChange textChange, NLSSubstitution[] substitutions, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap, PropertyFileDocumentModel model) {
        NLSSubstitution[] nLSSubstitutionArray = substitutions;
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key;
            KeyValuePair newPair;
            KeyValuePair initialPair;
            ReplaceEdit edit;
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (NLSPropertyFileModifier.doReplace(substitution, newKeyToSubstMap, oldKeyToSubstMap) && (edit = model.replace(initialPair = new KeyValuePair(substitution.getInitialKey(), substitution.getInitialValue()), newPair = new KeyValuePair(key = PropertyFileDocumentModel.escape(substitution.getKey(), false), value = PropertyFileDocumentModel.escape(substitution.getValue(), true) + model.getLineDelimiter()))) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_replace_entry, BasicElementLabels.getJavaElementName(substitution.getKey())), (TextEdit)edit);
            }
            ++n2;
        }
    }

    static boolean doInsert(NLSSubstitution substitution, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap) {
        if (substitution.getState() != 0) {
            return false;
        }
        if (!(substitution.hasStateChanged() || substitution.getInitialValue() == null || substitution.isKeyRename() && oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution)) {
            return false;
        }
        return newKeyToSubstMap.get(substitution.getKey()) == substitution;
    }

    private static void addInsertEdits(TextChange textChange, NLSSubstitution[] substitutions, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap, PropertyFileDocumentModel model) {
        ArrayList<KeyValuePair> keyValuePairsToAdd = new ArrayList<KeyValuePair>();
        NLSSubstitution[] nLSSubstitutionArray = substitutions;
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (NLSPropertyFileModifier.doInsert(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                String value = PropertyFileDocumentModel.escape(substitution.getValueNonEmpty(), true) + model.getLineDelimiter();
                String key = PropertyFileDocumentModel.escape(substitution.getKey(), false);
                keyValuePairsToAdd.add(new KeyValuePair(key, value));
            }
            ++n2;
        }
        if (keyValuePairsToAdd.size() > 0) {
            model.insert(keyValuePairsToAdd.toArray(new KeyValuePair[keyValuePairsToAdd.size()]), textChange);
        }
    }

    static boolean doRemove(NLSSubstitution substitution, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap) {
        if (substitution.getInitialState() != 0 || substitution.getInitialKey() == null) {
            return false;
        }
        if (oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution) {
            return false;
        }
        return substitution.hasStateChanged() || substitution.hasPropertyFileChange() && newKeyToSubstMap.get(substitution.getKey()) != substitution;
    }

    private static void addRemoveEdits(TextChange textChange, NLSSubstitution[] substitutions, Map<String, NLSSubstitution> newKeyToSubstMap, Map<String, NLSSubstitution> oldKeyToSubstMap, PropertyFileDocumentModel model) {
        NLSSubstitution[] nLSSubstitutionArray = substitutions;
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            DeleteEdit edit;
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (NLSPropertyFileModifier.doRemove(substitution, newKeyToSubstMap, oldKeyToSubstMap) && (edit = model.remove(substitution.getInitialKey())) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_remove_entry, BasicElementLabels.getJavaElementName(substitution.getInitialKey())), (TextEdit)edit);
            }
            ++n2;
        }
    }

    private NLSPropertyFileModifier() {
    }
}

