/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class OverriddenAssignmentFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String IGNORE_LEADING_COMMENT = "ignoreLeadingComment";

    public static ICleanUpFix createCleanUp(final CompilationUnit unit, final boolean canMoveDecl) {
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                VariableDeclarationFragment fragment = ASTNodes.getUniqueFragment((Statement)node);
                if (fragment != null && (fragment.getInitializer() == null || ASTNodes.isPassiveWithoutFallingThrough((ASTNode)fragment.getInitializer()))) {
                    SimpleName varName = fragment.getName();
                    IVariableBinding variable = fragment.resolveBinding();
                    if (variable != null) {
                        Object stmtToInspect;
                        Statement firstSibling = stmtToInspect = ASTNodes.getNextSibling((Statement)node);
                        Assignment overridingAssignment = null;
                        boolean shouldMoveDown = true;
                        while (stmtToInspect != null) {
                            VarDefinitionsUsesVisitor varDefinitionsUsesVisitor = new VarDefinitionsUsesVisitor(variable, (ASTNode)stmtToInspect, true);
                            if (!varDefinitionsUsesVisitor.getReads().isEmpty()) {
                                return true;
                            }
                            Assignment assignment = ASTNodes.asExpression(stmtToInspect, Assignment.class);
                            if (assignment != null && ASTNodes.isSameVariable((ASTNode)varName, (ASTNode)assignment.getLeftHandSide())) {
                                if (!ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0])) {
                                    return true;
                                }
                                overridingAssignment = assignment;
                                break;
                            }
                            shouldMoveDown &= varDefinitionsUsesVisitor.getWrites().isEmpty();
                            stmtToInspect = fragment.getInitializer() == null ? null : ASTNodes.getNextSibling(stmtToInspect);
                        }
                        if (overridingAssignment != null && this.doesNotShareLines((ASTNode)node) && this.doesNotShareLines((ASTNode)overridingAssignment)) {
                            rewriteOperations.add(new OverriddenAssignmentOperation(node, fragment, overridingAssignment, firstSibling == stmtToInspect, shouldMoveDown && canMoveDecl));
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean doesNotShareLines(ASTNode node) {
                int nextStartLine;
                Statement stmt = null;
                stmt = node instanceof Statement ? (Statement)node : ASTNodes.getFirstAncestorOrNull(node, Statement.class);
                if (stmt == null) {
                    return false;
                }
                int stmtStartLine = unit.getLineNumber(stmt.getStartPosition());
                int stmtEndLine = unit.getLineNumber(stmt.getStartPosition() + stmt.getLength());
                Statement prevStmt = ASTNodes.getPreviousSibling(stmt);
                if (prevStmt == null) {
                    ASTNode parent = stmt.getParent();
                    while (parent != null && parent instanceof Block) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof Statement) {
                        prevStmt = (Statement)parent;
                    }
                }
                Statement nextStmt = ASTNodes.getNextStatement(stmt);
                int prevEndLine = prevStmt == null ? -1 : unit.getLineNumber(prevStmt.getStartPosition() + prevStmt.getLength());
                int n = nextStartLine = nextStmt == null ? Integer.MAX_VALUE : unit.getLineNumber(nextStmt.getStartPosition());
                return stmtStartLine > prevEndLine && stmtEndLine < nextStartLine;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.OverriddenAssignmentCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    protected OverriddenAssignmentFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class OverriddenAssignmentOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final VariableDeclarationStatement declaration;
        private final Assignment overridingAssignment;
        private final boolean followsImmediately;
        private final boolean moveDown;
        private final VariableDeclarationFragment fragment;

        public OverriddenAssignmentOperation(VariableDeclarationStatement declaration, VariableDeclarationFragment fragment, Assignment overridingAssignment, boolean followsImmediately, boolean moveDown) {
            this.declaration = declaration;
            this.fragment = fragment;
            this.overridingAssignment = overridingAssignment;
            this.followsImmediately = followsImmediately;
            this.moveDown = moveDown;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    ASTNode root;
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty(OverriddenAssignmentFixCore.IGNORE_LEADING_COMMENT)) && (root = nodeWithComment.getRoot()) instanceof CompilationUnit) {
                        CompilationUnit cu = (CompilationUnit)root;
                        int extendedEnd = cu.getExtendedStartPosition(nodeWithComment) + cu.getExtendedLength(nodeWithComment);
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), extendedEnd - nodeWithComment.getStartPosition());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.OverriddenAssignmentCleanUp_description, cuRewrite);
            boolean canMoveDown = this.overridingAssignment.getParent() instanceof ExpressionStatement;
            boolean canMoveUp = this.followsImmediately || this.canMoveUp();
            int start = this.fragment.getStartPosition() + this.fragment.getLength();
            int end = this.overridingAssignment.getStartPosition();
            final class DeclarationChecker
            extends ASTVisitor {
                private boolean preventsMoveUp = false;
                private final /* synthetic */ int val$start;
                private final /* synthetic */ int val$end;

                DeclarationChecker(int n, int n2) {
                    this.val$start = n;
                    this.val$end = n2;
                }

                private boolean preventsMoveUp(Name name) {
                    ASTNode var;
                    IBinding binding = name.resolveBinding();
                    return binding instanceof IVariableBinding && (var = ASTNodes.findDeclaration(binding, OverriddenAssignmentOperation.this.fragment.getRoot())) != null && (var.getStartPosition() >= this.val$start || var.getStartPosition() <= this.val$end - var.getLength());
                }

                public boolean visit(QualifiedName node) {
                    this.preventsMoveUp |= this.preventsMoveUp((Name)node);
                    return false;
                }

                public boolean visit(SimpleName node) {
                    this.preventsMoveUp |= this.preventsMoveUp((Name)node);
                    return false;
                }
            }
            DeclarationChecker declarationChecker = new DeclarationChecker(start, end);
            this.overridingAssignment.getRightHandSide().accept((ASTVisitor)declarationChecker);
            if (canMoveUp &= !declarationChecker.preventsMoveUp) {
                this.moveUp(cuRewrite, group);
            } else if (canMoveDown && this.moveDown) {
                this.moveDown(cuRewrite, group);
            } else {
                this.removeInitializer(cuRewrite, group);
            }
        }

        private boolean canMoveUp() {
            if (!ASTNodes.isPassiveWithoutFallingThrough((ASTNode)this.overridingAssignment.getRightHandSide())) {
                return false;
            }
            Block containingBlock = ASTNodes.getTypedAncestor((ASTNode)this.declaration, Block.class);
            class UndefinedVarsFinder
            extends InterruptibleVisitor {
                boolean preventsMoveUp = false;
                private final /* synthetic */ Block val$containingBlock;

                UndefinedVarsFinder(Block block) {
                    this.val$containingBlock = block;
                }

                public boolean visit(SimpleName node) {
                    IBinding usedBinding = node.resolveBinding();
                    if (usedBinding == null) {
                        this.preventsMoveUp = true;
                        return this.interruptVisit();
                    }
                    ASTNode usedName = ASTNodes.findDeclaration(usedBinding, (ASTNode)this.val$containingBlock);
                    if (usedName != null && usedName.getStartPosition() > OverriddenAssignmentOperation.this.declaration.getStartPosition()) {
                        this.preventsMoveUp = true;
                        return this.interruptVisit();
                    }
                    return super.visit(node);
                }
            }
            UndefinedVarsFinder visitor = new UndefinedVarsFinder(containingBlock);
            visitor.traverseNodeInterruptibly((ASTNode)this.overridingAssignment.getRightHandSide());
            return !visitor.preventsMoveUp;
        }

        private void removeInitializer(CompilationUnitRewrite cuRewrite, TextEditGroup group) throws JavaModelException {
            ICompilationUnit cu = cuRewrite.getCu();
            int nameEnd = this.fragment.getName().getStartPosition() + this.fragment.getName().getLength();
            String declarationText = cu.getBuffer().getText(this.declaration.getStartPosition(), nameEnd - this.declaration.getStartPosition());
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            ASTNode replacementNode = astRewrite.createStringPlaceholder(declarationText + ";", 60);
            this.declaration.setProperty(OverriddenAssignmentFixCore.IGNORE_LEADING_COMMENT, (Object)Boolean.TRUE);
            astRewrite.replace((ASTNode)this.declaration, replacementNode, group);
        }

        private void moveUp(CompilationUnitRewrite cuRewrite, TextEditGroup group) throws JavaModelException {
            ICompilationUnit cu = cuRewrite.getCu();
            Expression rhs = this.overridingAssignment.getRightHandSide();
            String rhsText = cu.getBuffer().getText(this.extendedStart(cuRewrite.getRoot(), (ASTNode)rhs), this.extendedEnd(cuRewrite.getRoot(), this.overridingAssignment.getParent()) - this.extendedStart(cuRewrite.getRoot(), (ASTNode)rhs));
            String targetText = null;
            if (this.fragment.getInitializer() == null) {
                declarationText = cu.getBuffer().getText(this.declaration.getStartPosition(), this.declaration.getLength() - 1);
                Hashtable options = JavaCore.getOptions();
                String spaceBeforeAssignment = options.get("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator") == "insert" ? " " : "";
                String spaceAfterAssignment = options.get("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator") == "insert" ? " " : "";
                targetText = declarationText + spaceBeforeAssignment + "=" + spaceAfterAssignment + rhsText;
            } else {
                declarationText = cu.getBuffer().getText(this.declaration.getStartPosition(), this.fragment.getInitializer().getStartPosition() - this.declaration.getStartPosition());
                targetText = declarationText + rhsText;
            }
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            ASTNode replacementNode = astRewrite.createStringPlaceholder(targetText, 60);
            this.declaration.setProperty(OverriddenAssignmentFixCore.IGNORE_LEADING_COMMENT, (Object)Boolean.TRUE);
            astRewrite.replace((ASTNode)this.declaration, replacementNode, group);
            astRewrite.remove(this.overridingAssignment.getParent(), group);
        }

        private void moveDown(CompilationUnitRewrite cuRewrite, TextEditGroup group) throws JavaModelException {
            ICompilationUnit cu = cuRewrite.getCu();
            Expression rhs = this.overridingAssignment.getRightHandSide();
            String rhsText = cu.getBuffer().getText(rhs.getStartPosition(), this.extendedEnd(cuRewrite.getRoot(), this.overridingAssignment.getParent()) - rhs.getStartPosition());
            Object declarationText = "";
            if (this.fragment.getInitializer() != null) {
                declarationText = cu.getBuffer().getText(this.declaration.getStartPosition(), this.fragment.getInitializer().getStartPosition() - this.declaration.getStartPosition());
            } else {
                declarationText = cu.getBuffer().getText(this.declaration.getStartPosition(), this.fragment.getStartPosition() + this.fragment.getLength() - this.declaration.getStartPosition());
                Hashtable options = JavaCore.getOptions();
                String spaceBeforeAssignment = options.get("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator") == "insert" ? " " : "";
                String spaceAfterAssignment = options.get("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator") == "insert" ? " " : "";
                declarationText = (String)declarationText + spaceBeforeAssignment + "=" + spaceAfterAssignment;
            }
            String targetText = (String)declarationText + rhsText;
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            ASTNode replacementNode = astRewrite.createStringPlaceholder(targetText, 60);
            this.overridingAssignment.getParent().setProperty(OverriddenAssignmentFixCore.IGNORE_LEADING_COMMENT, (Object)Boolean.TRUE);
            astRewrite.remove((ASTNode)this.declaration, group);
            ASTNodes.replaceButKeepComment(astRewrite, this.overridingAssignment.getParent(), replacementNode, group);
        }

        int extendedEnd(CompilationUnit cu, ASTNode node) {
            return cu.getExtendedStartPosition(node) + cu.getExtendedLength(node);
        }

        int extendedStart(CompilationUnit cu, ASTNode node) {
            return cu.getExtendedStartPosition(node);
        }
    }
}

